/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.results;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import org.aksw.rdfunit.enums.TestCaseResultStatus;
import org.aksw.rdfunit.services.PrefixService;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.results.StatusTestCaseResult;

public class AggregatedTestCaseResult
extends StatusTestCaseResult {
    private final long errorCount;
    private final long prevalenceCount;

    public AggregatedTestCaseResult(TestCase testCase, long errorCount, long prevalenceCount) {
        super(testCase, TestCaseResultStatus.resolve(errorCount));
        this.errorCount = errorCount;
        this.prevalenceCount = prevalenceCount;
    }

    public AggregatedTestCaseResult(TestCase testCase, TestCaseResultStatus status, long errorCount, long prevalenceCount) {
        super(testCase, status);
        this.errorCount = errorCount;
        this.prevalenceCount = prevalenceCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getPrevalenceCount() {
        return this.prevalenceCount;
    }

    @Override
    public Resource serialize(Model model, String sourceURI) {
        return super.serialize(model, sourceURI).addProperty(RDF.type, (RDFNode)model.createResource(PrefixService.getPrefix("rut") + "AggregatedTestResult")).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"resultCount"), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.errorCount), (RDFDatatype)XSDDatatype.XSDinteger)).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"resultPrevalence"), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.prevalenceCount), (RDFDatatype)XSDDatatype.XSDinteger));
    }

    public String toString() {
        return "Errors: " + this.errorCount + " / Prevalence: " + this.prevalenceCount + ". Test: " + this.getTestCase().getTestURI();
    }
}

