/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.executors.monitors;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Calendar;
import java.util.Collection;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.enums.TestCaseResultStatus;
import org.aksw.rdfunit.services.PrefixService;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.tests.executors.monitors.TestExecutorMonitor;
import org.aksw.rdfunit.tests.results.AggregatedTestCaseResult;
import org.aksw.rdfunit.tests.results.StatusTestCaseResult;
import org.aksw.rdfunit.tests.results.TestCaseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTestExecutorMonitor
implements TestExecutorMonitor {
    private static final Logger log = LoggerFactory.getLogger(SimpleTestExecutorMonitor.class);
    private final Model model;
    final String executionUUID;
    private Source testedDataset;
    private TestSuite testSuite;
    private long counter = 0L;
    private long totalTests = 0L;
    private long success = 0L;
    private long fail = 0L;
    private long timeout = 0L;
    private long error = 0L;
    private long totalErrors = 0L;
    XSDDateTime startTime;
    XSDDateTime endTime;

    public SimpleTestExecutorMonitor() {
        this(ModelFactory.createDefaultModel());
    }

    public SimpleTestExecutorMonitor(Model model) {
        this.model = model;
        model.setNsPrefixes(PrefixService.getPrefixMap());
        this.executionUUID = JenaUUID.generate().asString();
    }

    @Override
    public void testingStarted(Source dataset, TestSuite testSuite) {
        this.testedDataset = dataset;
        this.testSuite = testSuite;
        this.totalTests = testSuite.size();
        this.totalErrors = 0L;
        this.error = 0L;
        this.timeout = 0L;
        this.fail = 0L;
        this.success = 0L;
        this.counter = 0L;
        log.info("Testing " + this.testedDataset.getUri());
    }

    @Override
    public void singleTestStarted(TestCase test) {
        ++this.counter;
        this.startTime = new XSDDateTime(Calendar.getInstance());
    }

    @Override
    public void singleTestExecuted(TestCase test, TestCaseResultStatus status, Collection<TestCaseResult> results) {
        if (status.equals((Object)TestCaseResultStatus.Error)) {
            ++this.error;
        }
        if (status.equals((Object)TestCaseResultStatus.Timeout)) {
            ++this.timeout;
        }
        if (status.equals((Object)TestCaseResultStatus.Success)) {
            ++this.success;
        }
        if (status.equals((Object)TestCaseResultStatus.Fail)) {
            ++this.fail;
        }
        for (TestCaseResult result : results) {
            result.serialize(this.getModel(), this.executionUUID);
        }
        boolean statusResult = false;
        if (results.size() == 1) {
            TestCaseResult result;
            result = RDFUnitUtils.getFirstItemInCollection(results);
            assert (result != null);
            if (result instanceof StatusTestCaseResult) {
                long errorCount;
                statusResult = true;
                log.info("Test " + this.counter + "/" + this.totalTests + " returned " + result.toString());
                if (result instanceof AggregatedTestCaseResult && (errorCount = ((AggregatedTestCaseResult)result).getErrorCount()) > 0L) {
                    this.totalErrors += ((AggregatedTestCaseResult)result).getErrorCount();
                }
            }
        }
        if (!statusResult) {
            this.totalErrors += (long)results.size();
        }
    }

    @Override
    public void testingFinished() {
        this.endTime = new XSDDateTime(Calendar.getInstance());
        Resource testSuiteResource = this.testSuite.serialize(this.getModel());
        this.getModel().createResource(this.executionUUID).addProperty(RDF.type, (RDFNode)this.getModel().createResource(PrefixService.getPrefix("rut") + "TestExecution")).addProperty(RDF.type, (RDFNode)this.getModel().createResource(PrefixService.getPrefix("prov") + "Activity")).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("prov"), (String)"used"), (RDFNode)testSuiteResource).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("prov"), (String)"startedAtTime"), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.startTime), (RDFDatatype)XSDDatatype.XSDdateTime)).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("prov"), (String)"endedAtTime"), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.endTime), (RDFDatatype)XSDDatatype.XSDdateTime)).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"source"), (RDFNode)this.getModel().createResource(this.testedDataset.getUri())).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"testsRun"), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.totalTests), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"testsSuceedded"), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.success), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"testsFailed"), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.fail), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"testsTimeout"), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.timeout), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"testsError"), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.error), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"totalIndividualErrors"), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.totalErrors), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger));
        log.info("Tests run: " + this.totalTests + ", Failed: " + this.fail + ", Timeout: " + this.timeout + ", Error: " + this.error + ". Individual Errors: " + this.totalErrors);
    }

    public Model getModel() {
        return this.model;
    }
}

