/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.executors;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.rdfunit.exceptions.TestCaseExecutionException;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.executors.TestExecutor;
import org.aksw.rdfunit.tests.results.RLOGTestCaseResult;
import org.aksw.rdfunit.tests.results.TestCaseResult;

public class RLOGTestExecutor
extends TestExecutor {
    @Override
    protected Collection<TestCaseResult> executeSingleTest(Source source, TestCase testCase) throws TestCaseExecutionException {
        ArrayList<TestCaseResult> testCaseResults = new ArrayList<TestCaseResult>();
        try (QueryExecution qe = null;){
            qe = source.getExecutionFactory().createQueryExecution(testCase.getSparqlAnnotatedQuery());
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                testCaseResults.add(this.generateSingleResult(results.next(), testCase));
            }
        }
        return testCaseResults;
    }

    protected TestCaseResult generateSingleResult(QuerySolution qs, TestCase testCase) {
        String resource = qs.get("resource").toString();
        String message = testCase.getResultMessage();
        if (qs.contains("message")) {
            message = qs.get("message").toString();
        }
        String logLevel = testCase.getLogLevel();
        return new RLOGTestCaseResult(testCase, resource, message, logLevel);
    }
}

