/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collection;
import org.aksw.rdfunit.services.PrefixService;
import org.aksw.rdfunit.tests.TestCase;

public class TestSuite {
    private final Collection<TestCase> testCases;

    public TestSuite(Collection<TestCase> testCases) {
        this.testCases = testCases;
    }

    public Collection<TestCase> getTestCases() {
        return this.testCases;
    }

    public void setTestCases(Collection<TestCase> testCases) {
        this.testCases.clear();
        this.testCases.addAll(testCases);
    }

    public int size() {
        return this.testCases.size();
    }

    public Resource serialize(Model model) {
        Resource resource = model.createResource(JenaUUID.generate().asString()).addProperty(RDF.type, (RDFNode)model.createResource(PrefixService.getPrefix("rut") + "TestSuite")).addProperty(RDF.type, (RDFNode)model.createResource(PrefixService.getPrefix("prov") + "Collection"));
        for (TestCase tc : this.testCases) {
            resource.addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("prov"), (String)"hadMember"), (RDFNode)model.createResource(tc.getTestURI()));
        }
        return resource;
    }
}

