/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import org.aksw.rdfunit.enums.PatternParameterConstraints;
import org.aksw.rdfunit.exceptions.BindingException;
import org.aksw.rdfunit.patterns.PatternParameter;
import org.aksw.rdfunit.services.PrefixService;

public class Binding {
    private final PatternParameter parameter;
    private final RDFNode value;

    public Binding(PatternParameter parameter, RDFNode value) throws BindingException {
        this.parameter = parameter;
        this.value = value;
        if (!this.validateType()) {
            throw new BindingException("Binding is of incorrect constraint type");
        }
    }

    public String getValue() {
        if (this.value.isResource()) {
            return "<" + this.value.toString().trim().replace(" ", "") + ">";
        }
        return this.value.toString();
    }

    public String getParameterId() {
        return this.parameter.getId();
    }

    public Resource writeToModel(Model model) {
        return model.createResource().addProperty(RDF.type, (RDFNode)model.createResource(PrefixService.getPrefix("rut") + "Binding")).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"parameter"), (RDFNode)model.createResource(this.parameter.getURI())).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"bindingValue"), this.value);
    }

    private boolean validateType() {
        PatternParameterConstraints pc = this.parameter.getConstrain();
        if (pc.equals((Object)PatternParameterConstraints.None)) {
            return true;
        }
        if (this.value.isResource() && (pc.equals((Object)PatternParameterConstraints.Resource) || pc.equals((Object)PatternParameterConstraints.Property) || pc.equals((Object)PatternParameterConstraints.Class))) {
            return true;
        }
        return this.value.isLiteral() && pc.equals((Object)PatternParameterConstraints.Operator);
    }

    private boolean validatePattern() {
        if (this.parameter.getConstraintPattern().equals("")) {
            return true;
        }
        return true;
    }
}

