/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.patterns;

import java.util.Collection;
import org.aksw.rdfunit.patterns.PatternParameter;
import org.aksw.rdfunit.tests.results.ResultAnnotation;

public class Pattern {
    private final String id;
    private final String description;
    private final String sparqlWherePattern;
    private final String sparqlPatternPrevalence;
    private final Collection<PatternParameter> parameters;
    private final Collection<ResultAnnotation> annotations;

    public Pattern(String id, String description, String sparqlWherePattern, String sparqlPatternPrevalence, Collection<PatternParameter> parameters, Collection<ResultAnnotation> annotations) {
        this.id = id;
        this.description = description;
        this.sparqlWherePattern = sparqlWherePattern;
        this.sparqlPatternPrevalence = sparqlPatternPrevalence;
        this.parameters = parameters;
        this.annotations = annotations;
    }

    public boolean isValid() {
        if (this.getParameters() == null || this.getParameters().size() == 0) {
            return false;
        }
        for (PatternParameter p : this.getParameters()) {
            if (this.getSparqlWherePattern().contains("%%" + p.getId() + "%%")) continue;
            return false;
        }
        return true;
    }

    private boolean validateArguments() {
        return true;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSparqlWherePattern() {
        return this.sparqlWherePattern;
    }

    public String getSparqlPatternPrevalence() {
        return this.sparqlPatternPrevalence;
    }

    public Collection<PatternParameter> getParameters() {
        return this.parameters;
    }

    public PatternParameter getParameter(String parameterURI) {
        for (PatternParameter parameter : this.parameters) {
            if (!parameter.getURI().equals(parameterURI)) continue;
            return parameter;
        }
        return null;
    }

    public Collection<ResultAnnotation> getAnnotations() {
        return this.annotations;
    }
}

