/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.StringWriter;
import java.io.Writer;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.Utils.SparqlUtils;
import org.aksw.rdfunit.exceptions.TripleWriterException;
import org.aksw.rdfunit.io.DataWriter;
import org.aksw.rdfunit.services.PrefixService;

public class RDFStringWriter
extends DataWriter {
    private final StringBuilder str;
    private final String format;

    public RDFStringWriter() {
        this(new StringBuilder(), "TURTLE");
    }

    public RDFStringWriter(StringBuilder str) {
        this(str, "TURTLE");
    }

    public RDFStringWriter(StringBuilder str, String format) {
        this.str = str;
        this.format = format;
    }

    public String getString() {
        return this.str.toString();
    }

    @Override
    public void write(QueryExecutionFactory qef) throws TripleWriterException {
        try {
            StringWriter out = new StringWriter();
            Model model = SparqlUtils.getModelFromQueryFactory(qef);
            model.setNsPrefixes(PrefixService.getPrefixMap());
            model.write((Writer)out, this.format);
            this.str.append(out.toString());
        }
        catch (Exception e) {
            throw new TripleWriterException(e.getMessage());
        }
    }
}

