/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.Utils;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.aksw.rdfunit.io.DataReader;
import org.aksw.rdfunit.io.RDFFileReader;
import org.aksw.rdfunit.services.SchemaService;
import org.aksw.rdfunit.sources.DatasetSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFUnitUtils {
    private static final Logger log = LoggerFactory.getLogger(RDFUnitUtils.class);

    public static String getAllPrefixes() {
        return " PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n PREFIX owl: <http://www.w3.org/2002/07/owl#>\n PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> PREFIX dcterms: <http://purl.org/dc/terms/> \n PREFIX dc: <http://purl.org/dc/elements/1.1/> \n PREFIX rlog: <http://persistence.uni-leipzig.org/nlp2rdf/ontologies/rlog#> \n PREFIX prov: <http://www.w3.org/ns/prov#> \n PREFIX rut: <http://rdfunit.aksw.org/ns/core#> \n PREFIX rutp: <http://rdfunit.aksw.org/data/patterns#> \n PREFIX rutt: <http://rdfunit.aksw.org/data/tests#> \n PREFIX rutg: <http://rdfunit.aksw.org/data/generators#> \n";
    }

    public static void fillSchemaServiceFromFile(String additionalCSV) {
        int count = 0;
        if (additionalCSV != null && !additionalCSV.isEmpty()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(additionalCSV), "UTF-8"));
                String line = null;
                block8: while ((line = in.readLine()) != null) {
                    if (line.startsWith("#") || line.trim().isEmpty()) continue;
                    ++count;
                    String[] parts = line.split(",");
                    switch (parts.length) {
                        case 2: {
                            SchemaService.addSchemaDecl(parts[0], parts[1]);
                            continue block8;
                        }
                        case 3: {
                            SchemaService.addSchemaDecl(parts[0], parts[1], parts[2]);
                            continue block8;
                        }
                    }
                    log.error("Invalid schema declaration in " + additionalCSV + ". Line: " + line);
                    --count;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            log.info("Loaded " + count + " schema declarations from: " + additionalCSV);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillSchemaServiceFromLOV() {
        ArrayList sources = new ArrayList();
        DatasetSource lov = new DatasetSource("lov", "http://lov.okfn.org", "http://lov.okfn.org/endpoint/lov", new ArrayList<String>(), null);
        int count = 0;
        try (QueryExecution qe = null;){
            qe = lov.getExecutionFactory().createQueryExecution("PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX xsd:<http://www.w3.org/2001/XMLSchema#>\nPREFIX dcterms:<http://purl.org/dc/terms/>\nPREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl:<http://www.w3.org/2002/07/owl#>\nPREFIX skos:<http://www.w3.org/2004/02/skos/core#>\nPREFIX foaf:<http://xmlns.com/foaf/0.1/>\nPREFIX void:<http://rdfs.org/ns/void#>\nPREFIX bibo:<http://purl.org/ontology/bibo/>\nPREFIX vann:<http://purl.org/vocab/vann/>\nPREFIX voaf:<http://purl.org/vocommons/voaf#>\nPREFIX frbr:<http://purl.org/vocab/frbr/core#>\nPREFIX lov:<http://lov.okfn.org/dataset/lov/lov#>\n\nSELECT ?vocabPrefix ?vocabURI \nWHERE{\n\t?vocabURI a voaf:Vocabulary.\n\t?vocabURI vann:preferredNamespacePrefix ?vocabPrefix.\n} \nORDER BY ?vocabPrefix ");
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution row = rs.next();
                String prefix = row.get("vocabPrefix").toString();
                String vocab = row.get("vocabURI").toString();
                SchemaService.addSchemaDecl(prefix, vocab);
                ++count;
            }
        }
        log.info("Loaded " + count + " schema declarations from LOV SPARQL Endpoint");
    }

    public static boolean fileExists(String path) {
        File f = new File(path);
        return f.exists();
    }

    public static DataReader getPatternsFromResource() {
        return new RDFFileReader(RDFUnitUtils.class.getResourceAsStream("/org/aksw/rdfunit/patterns.ttl"));
    }

    public static DataReader getAutoGeneratorsFromResource() {
        return new RDFFileReader(RDFUnitUtils.class.getResourceAsStream("/org/aksw/rdfunit/testAutoGenerators.ttl"));
    }

    public static <T> T getFirstItemInCollection(Collection<T> collection) {
        Iterator<T> i$ = collection.iterator();
        if (i$.hasNext()) {
            T item = i$.next();
            return item;
        }
        return null;
    }
}

