/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.rdfunit.RDFUnit;
import org.aksw.rdfunit.RDFUnitConfiguration;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.coverage.TestCoverageEvaluator;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.exceptions.TripleReaderException;
import org.aksw.rdfunit.exceptions.TripleWriterException;
import org.aksw.rdfunit.io.DataFirstSuccessReader;
import org.aksw.rdfunit.io.DataMultipleWriter;
import org.aksw.rdfunit.io.DataReader;
import org.aksw.rdfunit.io.HTMLResultsWriter;
import org.aksw.rdfunit.io.RDFFileReader;
import org.aksw.rdfunit.io.RDFFileWriter;
import org.aksw.rdfunit.services.PrefixService;
import org.aksw.rdfunit.services.SchemaService;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.sources.SourceFactory;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.tests.executors.TestExecutor;
import org.aksw.rdfunit.tests.executors.TestGeneratorExecutor;
import org.aksw.rdfunit.tests.executors.monitors.SimpleTestExecutorMonitor;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final Options cliOptions = new Options();

    private static Collection<String> getUriStrs(String parameterStr) {
        ArrayList<String> uriStrs = new ArrayList<String>();
        if (parameterStr == null) {
            return uriStrs;
        }
        for (String uriStr : parameterStr.split(",")) {
            if (uriStr.trim().isEmpty()) continue;
            uriStrs.add(uriStr.trim());
        }
        return uriStrs;
    }

    public static void main(String[] args) throws Exception {
        String dumpLocation;
        String datasetUri;
        PropertyConfigurator.configure((String)"log4j.properties");
        GnuParser cliParser = new GnuParser();
        CommandLine commandLine = cliParser.parse(cliOptions, args);
        if (commandLine.hasOption("h") || !commandLine.hasOption("d")) {
            if (!commandLine.hasOption("h")) {
                Main.displayHelpAndExit("Error: Required arguments are missing.");
            } else {
                Main.displayHelpAndExit();
            }
        }
        if (commandLine.hasOption("e") && commandLine.hasOption("u")) {
            Main.displayHelpAndExit("Error: You have to select either an Endpoint or a Dump URI.");
        }
        if ((datasetUri = commandLine.getOptionValue("d")).endsWith("/")) {
            datasetUri = datasetUri.substring(0, datasetUri.length() - 1);
        }
        if ((dumpLocation = commandLine.getOptionValue("u")) == null || dumpLocation.isEmpty()) {
            dumpLocation = datasetUri;
        }
        String endpointUriStr = commandLine.getOptionValue("e");
        Collection<String> graphUriStrs = Main.getUriStrs(commandLine.getOptionValue("g", ""));
        Collection<String> schemaUriStrs = Main.getUriStrs(commandLine.getOptionValue("s"));
        String enrichedDatasetPrefix = commandLine.getOptionValue("p");
        String dataFolder = commandLine.getOptionValue("f", "../data/");
        String testFolder = dataFolder + "tests/";
        boolean useTestCache = !commandLine.hasOption("ntc");
        boolean useManualTestCases = !commandLine.hasOption("nmt");
        TestCaseExecutionType resultLevel = TestCaseExecutionType.aggregatedTestCaseResult;
        if (commandLine.hasOption("r")) {
            String rl = commandLine.getOptionValue("r", "aggregate");
            if (rl.equals("status")) {
                resultLevel = TestCaseExecutionType.statusTestCaseResult;
            } else if (rl.equals("aggregate")) {
                resultLevel = TestCaseExecutionType.aggregatedTestCaseResult;
            } else if (rl.equals("rlog")) {
                resultLevel = TestCaseExecutionType.rlogTestCaseResult;
            } else if (rl.equals("extended")) {
                resultLevel = TestCaseExecutionType.extendedTestCaseResult;
            } else {
                log.warn("Option --result-level defined but not recognised. Using 'aggregate' by default.");
            }
        }
        if (commandLine.hasOption("l")) {
            Main.displayHelpAndExit("Option -l was changed to -r, -l is reserved for --logging-level (notice, warn, error)");
        }
        boolean calculateCoverage = commandLine.hasOption("c");
        if (!RDFUnitUtils.fileExists(dataFolder)) {
            log.error("Path : " + dataFolder + " does not exists, use -f argument");
            System.exit(1);
        }
        RDFUnitUtils.fillSchemaServiceFromLOV();
        RDFUnitUtils.fillSchemaServiceFromFile(dataFolder + "schemaDecl.csv");
        RDFFileReader patternReader_data = new RDFFileReader(dataFolder + "patterns.ttl");
        DataReader patternReader_resource = RDFUnitUtils.getPatternsFromResource();
        DataFirstSuccessReader patternReader = new DataFirstSuccessReader(Arrays.asList(patternReader_data, patternReader_resource));
        RDFFileReader testGeneratorReader_data = new RDFFileReader(dataFolder + "testAutoGenerators.ttl");
        DataReader testGeneratorReader_resource = RDFUnitUtils.getAutoGeneratorsFromResource();
        DataFirstSuccessReader testGeneratorReader = new DataFirstSuccessReader(Arrays.asList(testGeneratorReader_data, testGeneratorReader_resource));
        RDFUnit rdfunit = new RDFUnit();
        try {
            rdfunit.initPatternsAndGenerators(patternReader, testGeneratorReader);
        }
        catch (TripleReaderException e) {
            log.error("Cannot read patterns and/or pattern generators");
            System.exit(1);
        }
        Collection<SchemaSource> sources = SchemaService.getSourceList(testFolder, schemaUriStrs);
        if (enrichedDatasetPrefix != null) {
            sources.add(SourceFactory.createEnrichedSchemaSourceFromCache(testFolder, enrichedDatasetPrefix, datasetUri));
        }
        RDFUnitConfiguration testContext = null;
        testContext = endpointUriStr == null || endpointUriStr.isEmpty() ? new RDFUnitConfiguration(datasetUri, dumpLocation, sources) : new RDFUnitConfiguration(datasetUri, endpointUriStr, graphUriStrs, sources);
        Source dataset = testContext.getDatasetSource();
        TestGeneratorExecutor testGeneratorExecutor = new TestGeneratorExecutor(useTestCache, useManualTestCases);
        TestSuite testSuite = testGeneratorExecutor.generateTestSuite(testFolder, dataset, rdfunit.getAutoGenerators());
        TestCaseExecutionType resulLevelInner = resultLevel;
        TestExecutor testExecutor = TestExecutor.initExecutorFactory(resultLevel);
        if (testExecutor == null) {
            log.error("Cannot initialize test executor. Exiting");
            System.exit(1);
        }
        SimpleTestExecutorMonitor testExecutorMonitor = new SimpleTestExecutorMonitor();
        testExecutor.addTestExecutorMonitor(testExecutorMonitor);
        testExecutor.execute(dataset, testSuite, 0);
        try {
            String filename = "../data/results/" + dataset.getPrefix() + "." + resulLevelInner.toString();
            RDFFileWriter rdf = new RDFFileWriter(filename + ".ttl");
            HTMLResultsWriter html = HTMLResultsWriter.create(resulLevelInner, filename + ".html");
            DataMultipleWriter resultWriter = new DataMultipleWriter(Arrays.asList(rdf, html));
            resultWriter.write(testExecutorMonitor.getModel());
            log.info("Results stored in: " + filename + " ttl / html");
        }
        catch (TripleWriterException e) {
            log.error("Cannot write tests to file: " + e.getMessage());
        }
        if (calculateCoverage) {
            Model m = ModelFactory.createDefaultModel();
            m.setNsPrefixes(PrefixService.getPrefixMap());
            for (TestCase ut : testSuite.getTestCases()) {
                m.add(ut.getUnitTestModel());
            }
            TestCoverageEvaluator tce = new TestCoverageEvaluator();
            tce.calculateCoverage((QueryExecutionFactory)new QueryExecutionFactoryModel(m), dataset.getPrefix() + ".property.count", dataset.getPrefix() + ".class.count");
        }
    }

    private static void displayHelpAndExit(String errorMessage) {
        log.error(errorMessage);
        Main.displayHelpAndExit();
    }

    private static void displayHelpAndExit() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("rdfunit", cliOptions);
        System.exit(1);
    }

    static {
        cliOptions.addOption("h", "help", false, "show this help message");
        cliOptions.addOption("d", "dataset-uri", true, "the URI of the dataset (required)");
        cliOptions.addOption("e", "endpoint", true, "the endpoint to run the tests on (If no endpoint is provided RDFUnit will try to dereference the dataset-uri)");
        cliOptions.addOption("g", "graph", true, "the graphs to use (separate multiple graphs with ',' (no whitespaces) (defaults to '')");
        cliOptions.addOption("U", "uri", true, "the uri to use for dereferencing if not the same with `dataset`");
        cliOptions.addOption("s", "schemas", true, "the schemas used in the chosen graph (comma separated prefixes without whitespaces according to http://lov.okfn.org/)");
        cliOptions.addOption("p", "enriched-prefix", true, "the prefix of this dataset used for caching the schema enrichment, e.g. dbo");
        cliOptions.addOption("ntc", "no-test-cache", false, "Do not load cached automatically generated test cases, regenerate them (Cached test cases are loaded by default)");
        cliOptions.addOption("nmt", "no-manual-tests", false, "Do not load any manually defined test cases (Manual test cases are loaded by default)");
        cliOptions.addOption("r", "result-level", true, "Specify the result level for the error reporting. One of status, aggregate, rlog, extended (default is aggregate).");
        cliOptions.addOption("l", "logging-level", true, "Not supported at the moment! will filter test cases based on logging level (notice, warn, error, etc).");
        cliOptions.addOption("c", "test-coverage", false, "Calculate test-coverage scores");
        cliOptions.addOption("f", "data-folder", true, "the location of the data folder (defaults to '../data/' or '~/.rdfunit). If none exists, bundled versions will be loaded.'");
    }
}

