/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.executors;

import java.util.ArrayList;
import java.util.Collection;
import org.aksw.rdfunit.Utils.CacheUtils;
import org.aksw.rdfunit.Utils.TestUtils;
import org.aksw.rdfunit.enums.TestGenerationType;
import org.aksw.rdfunit.exceptions.TripleReaderException;
import org.aksw.rdfunit.io.RDFFileReader;
import org.aksw.rdfunit.io.RDFFileWriter;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.TestAutoGenerator;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.tests.executors.monitors.TestGeneratorExecutorMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGeneratorExecutor {
    private static final Logger log = LoggerFactory.getLogger(TestGeneratorExecutor.class);
    private boolean isCanceled = false;
    private final boolean loadFromCache;
    private final boolean useManualTests;
    private final Collection<TestGeneratorExecutorMonitor> progressMonitors = new ArrayList<TestGeneratorExecutorMonitor>();

    public TestGeneratorExecutor() {
        this.loadFromCache = true;
        this.useManualTests = true;
    }

    public TestGeneratorExecutor(boolean loadFromCache, boolean useManualTests) {
        this.loadFromCache = loadFromCache;
        this.useManualTests = useManualTests;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public TestSuite generateTestSuite(String testFolder, Source dataset, Collection<TestAutoGenerator> autoGenerators) {
        Collection<SchemaSource> sources = dataset.getReferencesSchemata();
        for (TestGeneratorExecutorMonitor monitor : this.progressMonitors) {
            monitor.generationStarted(dataset, sources.size());
        }
        ArrayList<TestCase> allTests = new ArrayList<TestCase>();
        for (SchemaSource s : sources) {
            if (this.isCanceled) break;
            log.info("Generating tests for: " + s.getUri());
            allTests.addAll(this.generateAutoTestsForSchemaSource(testFolder, s, autoGenerators));
            if (!this.useManualTests) continue;
            allTests.addAll(this.generateManualTestsForSource(testFolder, s));
        }
        if (!this.isCanceled && this.useManualTests) {
            allTests.addAll(this.generateManualTestsForSource(testFolder, dataset));
        }
        for (TestGeneratorExecutorMonitor monitor : this.progressMonitors) {
            monitor.generationFinished();
        }
        return new TestSuite(allTests);
    }

    private Collection<TestCase> generateAutoTestsForSchemaSource(String testFolder, SchemaSource s, Collection<TestAutoGenerator> autoGenerators) {
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        for (TestGeneratorExecutorMonitor monitor : this.progressMonitors) {
            monitor.sourceGenerationStarted(s, TestGenerationType.AutoGenerated);
        }
        try {
            String cachedTestsLocation = CacheUtils.getSourceAutoTestFile(testFolder, s);
            if (!this.loadFromCache) {
                cachedTestsLocation = "";
            }
            Collection<TestCase> testsAutoCached = TestUtils.instantiateTestsFromModel(new RDFFileReader(cachedTestsLocation).read());
            tests.addAll(testsAutoCached);
            log.info(s.getUri() + " contains " + testsAutoCached.size() + " automatically created tests (loaded from cache)");
        }
        catch (TripleReaderException e) {
            Collection<TestCase> testsAuto = TestUtils.instantiateTestsFromAG(autoGenerators, s);
            tests.addAll(testsAuto);
            TestUtils.writeTestsToFile(testsAuto, new RDFFileWriter(CacheUtils.getSourceAutoTestFile(testFolder, s)));
            log.info(s.getUri() + " contains " + testsAuto.size() + " automatically created tests");
        }
        for (TestGeneratorExecutorMonitor monitor : this.progressMonitors) {
            monitor.sourceGenerationExecuted(s, TestGenerationType.AutoGenerated, tests.size());
        }
        return tests;
    }

    private Collection<TestCase> generateManualTestsForSource(String testFolder, Source s) {
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        for (TestGeneratorExecutorMonitor monitor : this.progressMonitors) {
            monitor.sourceGenerationStarted(s, TestGenerationType.ManuallyGenerated);
        }
        try {
            Collection<TestCase> testsManuals = TestUtils.instantiateTestsFromModel(new RDFFileReader(CacheUtils.getSourceManualTestFile(testFolder, s)).read());
            tests.addAll(testsManuals);
            log.info(s.getUri() + " contains " + testsManuals.size() + " manually created tests");
        }
        catch (TripleReaderException e) {
            // empty catch block
        }
        for (TestGeneratorExecutorMonitor monitor : this.progressMonitors) {
            monitor.sourceGenerationExecuted(s, TestGenerationType.ManuallyGenerated, tests.size());
        }
        return tests;
    }

    public void addTestExecutorMonitor(TestGeneratorExecutorMonitor monitor) {
        this.progressMonitors.add(monitor);
    }

    public void removeTestExecutorMonitor(TestGeneratorExecutorMonitor monitor) {
        this.progressMonitors.remove(monitor);
    }
}

