/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.executors;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.sparql.engine.http.QueryExceptionHTTP;
import java.util.Arrays;
import java.util.Collection;
import org.aksw.rdfunit.Utils.SparqlUtils;
import org.aksw.rdfunit.enums.TestCaseResultStatus;
import org.aksw.rdfunit.exceptions.TestCaseExecutionException;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.executors.TestExecutor;
import org.aksw.rdfunit.tests.results.StatusTestCaseResult;
import org.aksw.rdfunit.tests.results.TestCaseResult;

public class StatusTestExecutor
extends TestExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<TestCaseResult> executeSingleTest(Source source, TestCase testCase) throws TestCaseExecutionException {
        TestCaseResultStatus status = TestCaseResultStatus.Error;
        QueryExecution qe = null;
        try {
            qe = source.getExecutionFactory().createQueryExecution(testCase.getSparqlAsAskQuery());
            boolean fail = qe.execAsk();
            status = fail ? TestCaseResultStatus.Fail : TestCaseResultStatus.Success;
        }
        catch (QueryExceptionHTTP e) {
            if (SparqlUtils.checkStatusForTimeout(e)) {
                status = TestCaseResultStatus.Timeout;
            }
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        return Arrays.asList(new StatusTestCaseResult(testCase, status));
    }
}

