/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.Utils.TestUtils;
import org.aksw.rdfunit.enums.TestGenerationType;
import org.aksw.rdfunit.exceptions.BindingException;
import org.aksw.rdfunit.exceptions.TestCaseInstantiationException;
import org.aksw.rdfunit.patterns.Pattern;
import org.aksw.rdfunit.patterns.PatternParameter;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.Binding;
import org.aksw.rdfunit.tests.PatternBasedTestCase;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestCaseAnnotation;
import org.aksw.rdfunit.tests.results.ResultAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAutoGenerator {
    private static final Logger log = LoggerFactory.getLogger(TestAutoGenerator.class);
    private final String URI;
    private final String description;
    private final String query;
    private final Pattern pattern;
    private final Collection<ResultAnnotation> annotations;

    public TestAutoGenerator(String uri, String description, String query, Pattern pattern, Collection<ResultAnnotation> annotations) {
        this.URI = uri;
        this.description = description;
        this.query = query;
        this.pattern = pattern;
        this.annotations = annotations;
        this.annotations.addAll(pattern.getAnnotations());
    }

    public boolean isValid() {
        Query q;
        if (this.pattern == null) {
            log.error(this.getURI() + " : Pattern " + this.getPattern() + " does not exist");
            return false;
        }
        try {
            q = QueryFactory.create((String)(RDFUnitUtils.getAllPrefixes() + this.getQuery()));
        }
        catch (Exception e) {
            log.error(this.getURI() + " Cannot parse query:\n" + RDFUnitUtils.getAllPrefixes() + this.getQuery());
            e.printStackTrace();
            return false;
        }
        List sv = q.getProjectVars();
        if (sv.size() != this.pattern.getParameters().size() + 1) {
            log.error(this.getURI() + " Select variables are different than Pattern parameters");
            return false;
        }
        return true;
    }

    public Collection<TestCase> generate(Source source) {
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        Query q = QueryFactory.create((String)(RDFUnitUtils.getAllPrefixes() + this.getQuery()));
        QueryExecution qe = source.getExecutionFactory().createQueryExecution(q);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution row = rs.next();
            ArrayList<Binding> bindings = new ArrayList<Binding>();
            ArrayList<String> references = new ArrayList<String>();
            String description = "";
            for (PatternParameter p : this.pattern.getParameters()) {
                if (row.contains(p.getId())) {
                    Binding b;
                    RDFNode n = row.get(p.getId());
                    try {
                        b = new Binding(p, n);
                    }
                    catch (BindingException e) {
                        log.error("Non valid binding for parameter " + p.getId() + " in AutoGenerator: " + this.getURI());
                        continue;
                    }
                    bindings.add(b);
                    if (!n.isResource() || p.getId().toLowerCase().equals("loglevel")) continue;
                    references.add(n.toString().trim().replace(" ", ""));
                    continue;
                }
                log.error("Not bindings for parameter " + p.getId() + "  in AutoGenerator: " + this.getURI());
                break;
            }
            if (bindings.size() != this.getPattern().getParameters().size()) {
                log.error("Bindings for pattern " + this.pattern.getId() + "  do not match in AutoGenerator: " + this.getURI());
                continue;
            }
            if (row.get("DESCRIPTION") == null) {
                log.error("No ?DESCRIPTION variable found in AutoGenerator: " + this.getURI());
                continue;
            }
            description = row.get("DESCRIPTION").toString();
            try {
                PatternBasedTestCase tc = new PatternBasedTestCase(TestUtils.generateTestURI(source.getPrefix(), this.getPattern(), bindings, this.URI), new TestCaseAnnotation(TestGenerationType.AutoGenerated, this.getURI(), source.getSourceType(), source.getUri(), references, description, "", this.annotations), this.pattern, bindings);
                tests.add(tc);
            }
            catch (TestCaseInstantiationException e) {
                log.error(e.getMessage());
                e.printStackTrace();
            }
        }
        return tests;
    }

    public String getURI() {
        return this.URI;
    }

    public String getDescription() {
        return this.description;
    }

    public String getQuery() {
        return this.query;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

