/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.io.DataWriter;
import org.aksw.rdfunit.io.HTMLResultsAggregateWriter;
import org.aksw.rdfunit.io.HTMLResultsRlogWriter;
import org.aksw.rdfunit.io.HTMLResultsStatusWriter;

public abstract class HTMLResultsWriter
extends DataWriter {
    private final String filename;

    public HTMLResultsWriter(String filename) {
        this.filename = filename;
    }

    public static HTMLResultsWriter create(TestCaseExecutionType type, String filename) {
        switch (type) {
            case statusTestCaseResult: {
                return new HTMLResultsStatusWriter(filename);
            }
            case aggregatedTestCaseResult: {
                return new HTMLResultsAggregateWriter(filename);
            }
            case rlogTestCaseResult: {
                return new HTMLResultsRlogWriter(filename);
            }
        }
        return null;
    }

    @Override
    public void write(QueryExecutionFactory qef) {
        Collection<String> testExecutionURIs = this.getTestExecutionURI(qef);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.filename));
            writer.append(this.getHeader());
            Iterator<String> i$ = testExecutionURIs.iterator();
            if (i$.hasNext()) {
                String te = i$.next();
                writer.append(this.getTestExecutionStats(qef, te));
                writer.append(this.getTestExecutionResults(qef, te));
            }
            writer.append(this.getFooter());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract StringBuffer getResultsHeader();

    protected abstract StringBuffer getResultsList(QueryExecutionFactory var1, String var2);

    private StringBuffer getHeader() {
        StringBuffer header = new StringBuffer();
        header.append("<!DOCTYPE html><html><head>");
        header.append("<link href=\"http://netdna.bootstrapcdn.com/bootstrap/3.1.1/css/bootstrap.min.css\" rel=\"stylesheet\">");
        header.append("</head><body>");
        return header;
    }

    private StringBuffer getFooter() {
        return new StringBuffer("</body></html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getTestExecutionURI(QueryExecutionFactory qef) {
        ArrayList<String> executionURIs = new ArrayList<String>();
        String sparql = RDFUnitUtils.getAllPrefixes() + " SELECT DISTINCT ?testExecution WHERE { ?testExecution a rut:TestExecution } ";
        QueryExecution qe = null;
        try {
            qe = qef.createQueryExecution(sparql);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                String te = qs.get("testExecution").toString();
                executionURIs.add(te);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        return executionURIs;
    }

    private StringBuffer getTestExecutionStats(QueryExecutionFactory qef, String testExecution) {
        StringBuffer stats = new StringBuffer();
        stats.append("<h1>TestExecution: " + testExecution + "</h1>");
        return stats;
    }

    private StringBuffer getTestExecutionResults(QueryExecutionFactory qef, String testExecution) {
        StringBuffer results = new StringBuffer();
        results.append("<h2>Results</h2>");
        results.append("<table><thead>");
        results.append(this.getResultsHeader());
        results.append("</thead><tbody>");
        results.append(this.getResultsList(qef, testExecution));
        results.append("</tbody></table>");
        return results;
    }
}

