/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.io.HTMLResultsWriter;
import org.aksw.rdfunit.services.PrefixService;

public class HTMLResultsStatusWriter
extends HTMLResultsWriter {
    public HTMLResultsStatusWriter(String filename) {
        super(filename);
    }

    @Override
    protected StringBuffer getResultsHeader() {
        return new StringBuffer("<tr><th>Status</th><th>Test Case</th></tr>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StringBuffer getResultsList(QueryExecutionFactory qef, String testExecutionURI) {
        StringBuffer results = new StringBuffer();
        String template = "<tr><td>%s</td><td>%s</td></tr>";
        String sparql = RDFUnitUtils.getAllPrefixes() + " SELECT DISTINCT ?resultStatus ?testcase WHERE {" + " ?s a rut:StatusTestCaseResult ; " + "    rut:resultStatus ?resultStatus ; " + "    rut:testCase ?testcase ;" + "} ";
        QueryExecution qe = null;
        try {
            qe = qef.createQueryExecution(sparql);
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                String resultStatus = qs.get("resultStatus").toString();
                String testcase = qs.get("testcase").toString();
                String row = String.format(template, resultStatus.replace(PrefixService.getPrefix("rut"), "rut:"), testcase.replace(PrefixService.getPrefix("rutt"), "rutt:"));
                results.append(row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        return results;
    }
}

