/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.aksw.rdfunit.Utils.CacheUtils;
import org.aksw.rdfunit.io.DataReaderFactory;
import org.aksw.rdfunit.services.SchemaService;
import org.aksw.rdfunit.sources.DatasetSource;
import org.aksw.rdfunit.sources.DumpSource;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;

public class RDFUnitConfiguration {
    private final String prefix;
    private final String uri;
    private final String endpoint;
    private final Collection<String> graphs;
    private final String dereferenceUri;
    private final Collection<SchemaSource> sources;

    public RDFUnitConfiguration(String prefix, String uri, String endpoint, Collection<String> graphs, Collection<SchemaSource> sources) {
        this.prefix = prefix;
        this.uri = uri;
        this.endpoint = endpoint;
        this.graphs = graphs;
        this.dereferenceUri = null;
        this.sources = sources;
    }

    public RDFUnitConfiguration(String uri, String endpoint, Collection<String> graphs, String[] sourcePrefixes) {
        this(uri, endpoint, graphs, SchemaService.getSourceList(null, Arrays.asList(sourcePrefixes)));
    }

    public RDFUnitConfiguration(String uri, String endpoint, Collection<String> graphs, String sourcePrefixes) {
        this(uri, endpoint, graphs, sourcePrefixes.split(","));
    }

    public RDFUnitConfiguration(String uri, String endpoint, Collection<String> graphs, Collection<SchemaSource> sources) {
        this(CacheUtils.getAutoPrefixForURI(uri), uri, endpoint, graphs, sources);
    }

    public RDFUnitConfiguration(String prefix, String uri, String dereferenceUri, Collection<SchemaSource> sources) {
        this.prefix = prefix;
        this.uri = uri;
        this.endpoint = null;
        this.graphs = new ArrayList<String>();
        this.dereferenceUri = dereferenceUri;
        this.sources = sources;
    }

    public RDFUnitConfiguration(String uri, String location, Collection<SchemaSource> sources) {
        this(CacheUtils.getAutoPrefixForURI(uri), uri, location, sources);
    }

    public Source getDatasetSource() {
        if ((this.endpoint == null || this.endpoint.equals("")) && (this.graphs == null || this.graphs.isEmpty())) {
            return new DumpSource(this.prefix, this.uri, DataReaderFactory.createFileOrDereferenceTripleReader(this.dereferenceUri), this.sources);
        }
        return new DatasetSource(this.prefix, this.uri, this.endpoint, this.graphs, this.sources);
    }
}

