/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qamel.OQA.sparql;

import java.io.File;
import org.aksw.qa.annotation.cache.PersistentCache;
import org.aksw.qamel.OQA.sparql.SPARQLInterface;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class TripleStore
implements SPARQLInterface {
    private static final String TAG = TripleStore.class.getSimpleName();
    private Repository sDatabase;
    private RepositoryConnection connection;
    private PersistentCache cache;
    private JSONParser parser;

    public TripleStore(String database) {
        File dbDir = new File(database);
        this.sDatabase = new SailRepository((Sail)new NativeStore(dbDir));
        this.sDatabase.initialize();
        this.sDatabase.isInitialized();
        this.connection = this.sDatabase.getConnection();
        this.cache = new PersistentCache();
        this.parser = new JSONParser();
    }

    @Override
    public JSONArray query(String sparqlQuery) throws ParseException {
        if (this.cache.containsKey(sparqlQuery = sparqlQuery.replace("\n", "").replace("\t", ""))) {
            String tmp = this.cache.get(sparqlQuery);
            JSONArray obj = (JSONArray)this.parser.parse(tmp);
            return obj;
        }
        TupleQuery tupleQuery = this.connection.prepareTupleQuery(sparqlQuery);
        TupleQueryResult result = tupleQuery.evaluate();
        JSONArray list = new JSONArray();
        try {
            while (result.hasNext()) {
                BindingSet set = (BindingSet)result.next();
                if (set.size() == 0) continue;
                JSONObject obj = new JSONObject();
                for (String b : result.getBindingNames()) {
                    obj.put((Object)b, (Object)set.getValue(b).stringValue());
                }
                list.add((Object)obj);
            }
            this.cache.put(sparqlQuery, list.toJSONString());
            this.cache.writeCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }
}

