/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qamel.OQA.sparql;

import org.aksw.qa.annotation.cache.PersistentCache;
import org.aksw.qamel.OQA.sparql.SPARQLInterface;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sparql.SPARQLRepository;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SPARQLEndpoint
implements SPARQLInterface {
    private static final String TAG = SPARQLEndpoint.class.getSimpleName();
    private RepositoryConnection connection;
    private PersistentCache cache;
    private JSONParser parser;

    public SPARQLEndpoint(String sPARQLEndpoint) {
        SPARQLRepository sparqlrepository = new SPARQLRepository(sPARQLEndpoint);
        sparqlrepository.initialize();
        this.connection = sparqlrepository.getConnection();
        this.cache = new PersistentCache();
        this.parser = new JSONParser();
    }

    @Override
    public JSONArray query(String sparqlQuery) throws Exception {
        if (this.cache.containsKey(sparqlQuery = sparqlQuery.replace("\n", "").replace("\t", ""))) {
            String tmp = this.cache.get(sparqlQuery);
            JSONArray obj = (JSONArray)this.parser.parse(tmp);
            return obj;
        }
        TupleQuery tupleQuery = this.connection.prepareTupleQuery(sparqlQuery);
        TupleQueryResult result = tupleQuery.evaluate();
        JSONArray list = new JSONArray();
        try {
            while (result.hasNext()) {
                BindingSet set = (BindingSet)result.next();
                if (set.size() == 0) continue;
                JSONObject obj = new JSONObject();
                for (String b : result.getBindingNames()) {
                    obj.put((Object)b, (Object)set.getValue(b).stringValue());
                }
                list.add((Object)obj);
            }
            this.cache.put(sparqlQuery, list.toJSONString());
            this.cache.writeCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }
}

