/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qamel.OQA.evaluation;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;
import org.aksw.qa.commons.measure.AnswerBasedEvaluation;
import org.aksw.qamel.OQA.OQA;
import org.aksw.qamel.OQA.QAResult;
import org.aksw.qamel.OQA.TextResult;

public class QALD7Benchmark {
    public static void main(String[] args) throws Exception {
        OQA app = new OQA(new File("Database"));
        List questions = LoaderController.load((Dataset)Dataset.QALD7_Train_Multilingual);
        int i = 0;
        double fmeasureavg = 0.0;
        for (IQuestion q : questions) {
            String question = (String)q.getLanguageToQuestion().get("en");
            QAResult[] results = app.answerQuestion(question);
            System.out.println(++i + " / " + questions.size());
            System.out.println("answer: " + ((TextResult)results[0]).getmData());
            HashSet<String> systemAnswer = new HashSet<String>(Arrays.asList(((TextResult)results[0]).getmData()));
            double precision = AnswerBasedEvaluation.precision(systemAnswer, (IQuestion)q);
            double recall = AnswerBasedEvaluation.recall(systemAnswer, (IQuestion)q);
            double fMeasure = AnswerBasedEvaluation.fMeasure(systemAnswer, (IQuestion)q);
            System.out.println("gold: " + (String)q.getGoldenAnswers().iterator().next());
            System.out.println("fmeasure: " + fMeasure);
            fmeasureavg += fMeasure;
        }
        System.out.println(fmeasureavg / (double)questions.size());
    }
}

