/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qamel.OQA;

import info.debatty.java.stringsimilarity.Levenshtein;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aksw.qamel.OQA.Answer;
import org.aksw.qamel.OQA.Match;
import org.aksw.qamel.OQA.QAResult;
import org.aksw.qamel.OQA.TextResult;
import org.aksw.qamel.OQA.sparql.SPARQLEndpoint;
import org.aksw.qamel.OQA.sparql.SPARQLInterface;
import org.aksw.qamel.OQA.sparql.TripleStore;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class OQA {
    private static final String QUERY_PREFIX = "PREFIX rdfs:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX  dbo: <http://dbpedia.org/ontology/> \nPREFIX  dbp: <http://dbpedia.org/property/> \nPREFIX  xsd: <http://www.w3.org/2001/XMLSchema#> \n";
    private static final String[] BLACKLIST = new String[]{"the", "is", "did", "do", "his", "her", "to", "does", "are", "was", "were", "he", "she", "it", "they", "of", "in", "at", "by", "why", "who", "where", "when", "what", "which", "year", "how", "has", "have", "a", "all", "much", "many", "list", "give", "me", "with"};
    private static final int QUESTION_TYPE_DATE = 1;
    private static final int QUESTION_TYPE_PLACE = 2;
    private static final int QUESTION_TYPE_PERSON = 4;
    private static final int QUESTION_TYPE_NUMBER = 8;
    private static final int QUESTION_TYPE_UNKNOWN = 16;
    private String mQuestion;
    private String[] mWords;
    private List<Match> mThings;
    private List<Match> mProperties;
    private int mQuestionType;
    public List<Answer> mAnswers;
    private SPARQLInterface sparql;

    public OQA(File database) {
        String mDatabasePath = database.getAbsolutePath();
        this.sparql = new TripleStore(mDatabasePath);
    }

    public OQA(String SPARQLEndpoint2) {
        this.sparql = new SPARQLEndpoint(SPARQLEndpoint2);
    }

    private void findMatches(String word) throws Exception {
        try {
            word = word.replaceAll(" ", ".*").toLowerCase();
            String candidatesQuery = "PREFIX rdfs:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX  dbo: <http://dbpedia.org/ontology/> \nPREFIX  dbp: <http://dbpedia.org/property/> \nPREFIX  xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT DISTINCT ?x ?z WHERE { ?x <http://www.w3.org/2000/01/rdf-schema#label> ?z FILTER regex(lcase(str(?x)), \"" + word + "\") FILTER (lang(?z)='en' ) } LIMIT 100";
            JSONArray result = this.sparql.query(candidatesQuery);
            this.checkBeforeInsertMatch(word, result);
        }
        catch (MalformedQueryException e) {
            System.err.println("Invalid query.");
            System.err.println(e.getLocalizedMessage());
        }
    }

    private void checkBeforeInsertMatch(String word, JSONArray result) {
        try {
            for (JSONObject set : result) {
                String uri = (String)set.get((Object)"x");
                String label = (String)set.get((Object)"z");
                this.insertMatch(word, uri, label);
            }
        }
        catch (QueryEvaluationException queryEvaluationException) {
            // empty catch block
        }
    }

    private void insertMatch(String word, String uri, String label) {
        Match match = new Match(uri, this.mQuestion, label, word);
        if (!uri.contains("/ontology/") && !uri.contains("/property/")) {
            for (Match m : this.mThings) {
                if (!m.getUri().equals(uri)) continue;
                m.addWord(word);
                return;
            }
            this.mThings.add(match);
        } else {
            for (Match m : this.mProperties) {
                if (!m.getUri().equals(uri)) continue;
                m.addWord(word);
                return;
            }
            this.mProperties.add(match);
        }
    }

    private void determineQuestionType() {
        this.mQuestionType = 0;
        if (this.mQuestion.contains("when")) {
            this.mQuestionType |= 1;
        }
        if (this.mQuestion.contains("where")) {
            this.mQuestionType |= 2;
        }
        if (this.mQuestion.contains("who")) {
            this.mQuestionType |= 4;
        }
        if (this.mQuestion.contains("when")) {
            this.mQuestionType |= 1;
        }
        if (this.mQuestion.contains("how many") || this.mQuestion.contains("how much")) {
            this.mQuestionType |= 8;
        }
        if (this.mQuestionType == 0) {
            this.mQuestionType = 16;
        }
    }

    public QAResult[] answerQuestion(String question) throws Exception {
        this.mQuestion = null;
        this.mWords = null;
        this.mThings = null;
        this.mProperties = null;
        this.mQuestionType = 0;
        this.mAnswers = null;
        System.out.println("******************************");
        System.out.println("Question original: " + question);
        question = question.replaceAll("[^A-Za-z0-9'.\\s]", " ");
        if (question.endsWith(".")) {
            question = question.substring(0, question.lastIndexOf("."));
        }
        question = question.replaceAll("\\s+", " ");
        this.mQuestion = question = question.toLowerCase();
        this.mAnswers = new ArrayList<Answer>();
        this.mThings = new ArrayList<Match>();
        this.mProperties = new ArrayList<Match>();
        this.determineQuestionType();
        this.mQuestion = " " + this.mQuestion + " ";
        for (String blacklisted : BLACKLIST) {
            this.mQuestion = this.mQuestion.replace(" " + blacklisted + " ", " ");
        }
        this.mQuestion = this.mQuestion.substring(1, this.mQuestion.length() - 1);
        this.mWords = this.mQuestion.split(" ");
        for (String word : this.mWords) {
            System.out.println(word);
            if (word.equals(" ") || word.equals("")) continue;
            this.findMatches(word);
        }
        Collections.sort(this.mThings, new Match.Comparator());
        Collections.sort(this.mProperties, new Match.Comparator());
        QAResult qaresult = this.findBestAnswer();
        return new QAResult[]{qaresult};
    }

    public QAResult findBestAnswer() throws Exception {
        int maxConfidence = Integer.MIN_VALUE;
        for (Match thing : this.mThings) {
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(QUERY_PREFIX).append("SELECT DISTINCT * WHERE {{}");
            if ((this.mQuestionType & 1) != 0) {
                queryBuilder.append("UNION { SELECT ?p ?o WHERE { <").append(thing.getUri()).append("> ?p ?o .\n FILTER (datatype(?o) = xsd:date)}}");
                queryBuilder.append("UNION { SELECT ?p ?o WHERE { <").append(thing.getUri()).append("> ?p ?o .\n FILTER (datatype(?o) = xsd:gYear)}}");
            }
            if ((this.mQuestionType & 2) != 0) {
                queryBuilder.append("UNION { SELECT ?p ?o WHERE { <").append(thing.getUri()).append("> ?p ?o .\n FILTER (datatype(?o) = xsd:place)}}");
                queryBuilder.append("UNION { SELECT ?p ?o WHERE { <").append(thing.getUri()).append("> ?p ?o .\n ?o rdf:type dbo:Place}}");
                queryBuilder.append("UNION { SELECT ?o ?p WHERE {?o ?p <").append(thing.getUri()).append("> .\n ?o rdf:type dbo:Place}}");
            }
            if ((this.mQuestionType & 4) != 0) {
                queryBuilder.append("UNION { SELECT ?p ?o WHERE { <").append(thing.getUri()).append("> ?p ?o .\n ?o rdf:type dbo:Person}}");
                queryBuilder.append("UNION { SELECT ?o ?p WHERE {?o ?p <").append(thing.getUri()).append("> .\n ?o rdf:type dbo:Person}}");
            }
            if ((this.mQuestionType & 0x10) != 0) {
                queryBuilder.append("UNION { SELECT ?p ?o WHERE { <").append(thing.getUri()).append("> ?p ?o .}}");
                queryBuilder.append("UNION { SELECT ?o ?p WHERE {?o ?p <").append(thing.getUri()).append("> .}}");
            }
            queryBuilder.append("}");
            JSONArray result = this.sparql.query(queryBuilder.toString());
            for (JSONObject next : result) {
                maxConfidence = Math.max(this.evaluateResult(thing, next), maxConfidence);
                if (maxConfidence < -thing.getDistance()) continue;
                Collections.sort(this.mAnswers, new Answer.Comparator());
                return new TextResult(this.mQuestion, this.mAnswers.get(0).getAnswer());
            }
        }
        Collections.sort(this.mAnswers, new Answer.Comparator());
        return new TextResult(this.mQuestion, "An error occurred");
    }

    private int evaluateResult(Match match, JSONObject next) throws Exception {
        if (next.get((Object)"p") == null || next.get((Object)"o") == null) {
            return Integer.MIN_VALUE;
        }
        String property = (String)next.get((Object)"p");
        String propertyLabel = this.getLabel(property);
        for (Match p : this.mProperties) {
            if (!p.getUri().equals(property)) continue;
            String string = (String)next.get((Object)"o");
            int confidence = -1 * match.getDistance() + match.getWordsLength() + match.getQuestion().length();
            this.mAnswers.add(new Answer(match, next, string, this.mQuestion, confidence, propertyLabel));
            return confidence;
        }
        if (propertyLabel == null) {
            propertyLabel = "";
        }
        int minDistance = Integer.MAX_VALUE;
        String word = "";
        for (String w : this.mWords) {
            int distance;
            if (w.equals(" ") || w.equals("") || minDistance <= (distance = (int)new Levenshtein().distance(w, propertyLabel))) continue;
            minDistance = distance;
            word = w;
        }
        String string = (String)next.get((Object)"o");
        int confidence = (int)((float)(-2 * match.getDistance()) - 10.0f * (float)minDistance / (float)word.length() + (float)match.getWordsLength());
        this.mAnswers.add(new Answer(match, next, string, this.mQuestion, confidence, word));
        return confidence;
    }

    public String getLabel(String uri) throws Exception {
        Value value;
        String query = "SELECT ?l WHERE { <" + uri + "> <http://www.w3.org/2000/01/rdf-schema#label> ?l. FILTER (lang(?l='en'))}";
        JSONArray labelResult = this.sparql.query(query);
        Iterator iter = labelResult.iterator();
        if (!iter.hasNext() || (value = ((BindingSet)iter.next()).getValue("l")) == null) {
            return null;
        }
        return value.stringValue();
    }
}

