/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qamel.OQA;

import info.debatty.java.stringsimilarity.Levenshtein;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aksw.qamel.OQA.Answer;
import org.aksw.qamel.OQA.Match;
import org.aksw.qamel.OQA.QAResult;
import org.aksw.qamel.OQA.TextResult;
import org.aksw.qamel.OQA.sparql.SPARQLEndpoint;
import org.aksw.qamel.OQA.sparql.SPARQLInterface;
import org.aksw.qamel.OQA.sparql.TripleStore;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.TupleQueryResult;

public class OQA {
    private static final String QUERY_PREFIX = "PREFIX rdfs:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX  dbo: <http://dbpedia.org/ontology/> \nPREFIX  dbp: <http://dbpedia.org/property/> \nPREFIX  xsd: <http://www.w3.org/2001/XMLSchema#> \n";
    private static final String[] BLACKLIST = new String[]{"the", "is", "did", "do", "his", "her", "to", "does", "are", "was", "were", "he", "she", "it", "they", "of", "in", "at", "by", "why", "who", "where", "when", "what", "which", "year", "how", "has", "have", "a", "all", "much", "many", "list", "give", "me", "with"};
    private static final int QUESTION_TYPE_DATE = 1;
    private static final int QUESTION_TYPE_PLACE = 2;
    private static final int QUESTION_TYPE_PERSON = 4;
    private static final int QUESTION_TYPE_NUMBER = 8;
    private static final int QUESTION_TYPE_UNKNOWN = 16;
    private String mQuestion;
    private String[] mWords;
    private List<Match> mThings;
    private List<Match> mProperties;
    private int mQuestionType;
    public List<Answer> mAnswers;
    private SPARQLInterface sparql;

    public OQA(File database) {
        String mDatabasePath = database.getAbsolutePath();
        this.sparql = new TripleStore(mDatabasePath);
    }

    public OQA(String SPARQLEndpoint2) {
        this.sparql = new SPARQLEndpoint(SPARQLEndpoint2);
    }

    private void findMatches(String word) {
        try {
            word = word.replaceAll(" ", ".*").toLowerCase();
            String candidatesQuery = "PREFIX rdfs:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX  dbo: <http://dbpedia.org/ontology/> \nPREFIX  dbp: <http://dbpedia.org/property/> \nPREFIX  xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT DISTINCT ?x ?z WHERE { ?x <http://www.w3.org/2000/01/rdf-schema#label> ?z FILTER regex(lcase(str(?x)), \"" + word + "\") FILTER (lang(?z)='en' && isURI(?x) ) } LIMIT 100";
            TupleQueryResult result = this.sparql.query(candidatesQuery);
            while (result.hasNext()) {
                BindingSet set = (BindingSet)result.next();
                String uri = set.getValue("x").stringValue();
                String label = set.getValue("z").stringValue();
                this.insertMatch(word, uri, label);
                System.out.println("\t " + word + ": " + uri + ", " + label);
            }
        }
        catch (MalformedQueryException e) {
            System.err.println("Invalid query.");
            System.err.println(e.getLocalizedMessage());
        }
    }

    private void insertMatch(String word, String uri, String label) {
        Match match = new Match(uri, this.mQuestion, label, word, this.getOccurrences(uri));
        if (match.getType() == 2) {
            for (Match m : this.mThings) {
                if (!m.getUri().equals(uri)) continue;
                m.addWord(word);
                return;
            }
            this.mThings.add(match);
        } else {
            for (Match m : this.mProperties) {
                if (!m.getUri().equals(uri)) continue;
                m.addWord(word);
                return;
            }
            this.mProperties.add(match);
        }
    }

    private int[] getOccurrences(String uri) {
        int[] occurrences = new int[3];
        String query = "PREFIX rdfs:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX  dbo: <http://dbpedia.org/ontology/> \nPREFIX  dbp: <http://dbpedia.org/property/> \nPREFIX  xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT (count (?x) as ?c) WHERE { <" + uri + "> ?x ?y }";
        occurrences[0] = Integer.parseInt(((BindingSet)this.sparql.query(query).next()).getValue("c").stringValue());
        query = "PREFIX rdfs:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX  dbo: <http://dbpedia.org/ontology/> \nPREFIX  dbp: <http://dbpedia.org/property/> \nPREFIX  xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT (count (?x) as ?c) WHERE { ?x <" + uri + "> ?y }";
        occurrences[1] = Integer.parseInt(((BindingSet)this.sparql.query(query).next()).getValue("c").stringValue());
        query = "PREFIX rdfs:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX  dbo: <http://dbpedia.org/ontology/> \nPREFIX  dbp: <http://dbpedia.org/property/> \nPREFIX  xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT (count (?x) as ?c) WHERE { <" + uri + "> ?x ?y }";
        occurrences[2] = Integer.parseInt(((BindingSet)this.sparql.query(query).next()).getValue("c").stringValue());
        return occurrences;
    }

    private void determineQuestionType() {
        this.mQuestionType = 0;
        if (this.mQuestion.contains("when")) {
            this.mQuestionType |= 1;
        }
        if (this.mQuestion.contains("where")) {
            this.mQuestionType |= 2;
        }
        if (this.mQuestion.contains("who")) {
            this.mQuestionType |= 4;
        }
        if (this.mQuestion.contains("when")) {
            this.mQuestionType |= 1;
        }
        if (this.mQuestion.contains("how many") || this.mQuestion.contains("how much")) {
            this.mQuestionType |= 8;
        }
        if (this.mQuestionType == 0) {
            this.mQuestionType = 16;
        }
    }

    public QAResult[] answerQuestion(String question) {
        System.out.println("******************************");
        System.out.println("Question original: " + question);
        question = question.replaceAll("[^A-Za-z0-9'.\\s]", " ");
        if (question.endsWith(".")) {
            question = question.substring(0, question.lastIndexOf("."));
        }
        question = question.replaceAll("\\s+", " ");
        this.mQuestion = question = question.toLowerCase();
        this.mAnswers = new ArrayList<Answer>();
        this.mThings = new ArrayList<Match>();
        this.mProperties = new ArrayList<Match>();
        this.determineQuestionType();
        this.mQuestion = " " + this.mQuestion + " ";
        for (String blacklisted : BLACKLIST) {
            this.mQuestion = this.mQuestion.replace(" " + blacklisted + " ", " ");
        }
        this.mQuestion = this.mQuestion.substring(1, this.mQuestion.length() - 1);
        this.mWords = this.mQuestion.split(" ");
        for (String word : this.mWords) {
            System.out.println(word);
            if (word.equals(" ") || word.equals("")) continue;
            this.findMatches(word);
        }
        Collections.sort(this.mThings, new Match.Comparator());
        Collections.sort(this.mProperties, new Match.Comparator());
        QAResult qaresult = this.findBestAnswer();
        return new QAResult[]{qaresult};
    }

    public QAResult findBestAnswer() {
        int maxConfidence = Integer.MIN_VALUE;
        for (Match thing : this.mThings) {
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(QUERY_PREFIX).append("SELECT DISTINCT * WHERE {{}");
            if ((this.mQuestionType & 1) != 0) {
                queryBuilder.append("UNION { SELECT ?p ?o WHERE { <").append(thing.getUri()).append("> ?p ?o .\n FILTER (datatype(?o) = xsd:date)}}");
                queryBuilder.append("UNION { SELECT ?p ?o WHERE { <").append(thing.getUri()).append("> ?p ?o .\n FILTER (datatype(?o) = xsd:gYear)}}");
            }
            if ((this.mQuestionType & 2) != 0) {
                queryBuilder.append("UNION { SELECT ?p ?o WHERE { <").append(thing.getUri()).append("> ?p ?o .\n FILTER (datatype(?o) = xsd:place)}}");
                queryBuilder.append("UNION { SELECT ?p ?o WHERE { <").append(thing.getUri()).append("> ?p ?o .\n ?o rdf:type dbo:Place}}");
                queryBuilder.append("UNION { SELECT ?o ?p WHERE {?o ?p <").append(thing.getUri()).append("> .\n ?o rdf:type dbo:Place}}");
            }
            if ((this.mQuestionType & 4) != 0) {
                queryBuilder.append("UNION { SELECT ?p ?o WHERE { <").append(thing.getUri()).append("> ?p ?o .\n ?o rdf:type dbo:Person}}");
                queryBuilder.append("UNION { SELECT ?o ?p WHERE {?o ?p <").append(thing.getUri()).append("> .\n ?o rdf:type dbo:Person}}");
            }
            if ((this.mQuestionType & 0x10) != 0) {
                queryBuilder.append("UNION { SELECT ?p ?o WHERE { <").append(thing.getUri()).append("> ?p ?o .}}");
                queryBuilder.append("UNION { SELECT ?o ?p WHERE {?o ?p <").append(thing.getUri()).append("> .}}");
            }
            queryBuilder.append("}");
            TupleQueryResult result = this.sparql.query(queryBuilder.toString());
            while (result.hasNext()) {
                BindingSet next = (BindingSet)result.next();
                maxConfidence = Math.max(this.evaluateResult(thing, next), maxConfidence);
                if (maxConfidence < -thing.getDistance()) continue;
                Collections.sort(this.mAnswers, new Answer.Comparator());
                return new TextResult(this.mQuestion, this.mAnswers.get(0).getAnswer());
            }
        }
        Collections.sort(this.mAnswers, new Answer.Comparator());
        return new TextResult(this.mQuestion, "An error occurred");
    }

    private int evaluateResult(Match match, BindingSet result) {
        if (result.getValue("p") == null || result.getValue("o") == null) {
            return Integer.MIN_VALUE;
        }
        String property = result.getValue("p").stringValue();
        String propertyLabel = this.getLabel(property);
        for (Match p : this.mProperties) {
            if (!p.getUri().equals(property)) continue;
            String string = result.getValue("o").stringValue();
            int confidence = -1 * match.getDistance() + match.getWordsLength() + match.getQuestion().length();
            this.mAnswers.add(new Answer(match, result, string, this.mQuestion, confidence, propertyLabel));
            return confidence;
        }
        if (propertyLabel == null) {
            propertyLabel = "";
        }
        int minDistance = Integer.MAX_VALUE;
        String word = "";
        for (String w : this.mWords) {
            int distance;
            if (w.equals(" ") || w.equals("") || minDistance <= (distance = (int)new Levenshtein().distance(w, propertyLabel))) continue;
            minDistance = distance;
            word = w;
        }
        String string = result.getValue("o").stringValue();
        int confidence = (int)((float)(-2 * match.getDistance()) - 10.0f * (float)minDistance / (float)word.length() + (float)match.getWordsLength());
        this.mAnswers.add(new Answer(match, result, string, this.mQuestion, confidence, word));
        return confidence;
    }

    public String getLabel(String uri) {
        Value value;
        String query = "SELECT ?l WHERE { <" + uri + "> <http://www.w3.org/2000/01/rdf-schema#label> ?l. FILTER (lang(?l='en'))}";
        TupleQueryResult labelResult = this.sparql.query(query);
        if (!labelResult.hasNext() || (value = ((BindingSet)labelResult.next()).getValue("l")) == null) {
            return null;
        }
        return value.stringValue();
    }
}

