/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qamel.OQA;

import info.debatty.java.stringsimilarity.Levenshtein;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Match {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PROPERTY = 1;
    public static final int TYPE_THING = 2;
    private int mDistance;
    private String mUri;
    private String mLabel;
    private List<String> mWords;
    private String mQuestion;
    private int[] mOccurrences;
    private int mType;
    private int mConfidence;

    public Match(String uri, String question, String label, String word, int[] occurrences) {
        this.mUri = uri;
        this.mLabel = label;
        this.mWords = new ArrayList<String>();
        this.mWords.add(word);
        this.mOccurrences = occurrences;
        this.mQuestion = question;
        Levenshtein levenshtein = new Levenshtein();
        this.mDistance = (int)levenshtein.distance(label, word);
        this.mType = this.mOccurrences[1] == 0 ? 2 : 1;
        this.mConfidence = 0;
    }

    public int getDistance() {
        return this.mDistance;
    }

    public String getUri() {
        return this.mUri;
    }

    public int getConfidence() {
        return this.mConfidence;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public String getWordsString() {
        return Arrays.toString(this.mWords.toArray());
    }

    public List<String> getWords() {
        return this.mWords;
    }

    public int getType() {
        return this.mType;
    }

    public String getQuestion() {
        return this.mQuestion;
    }

    public int getOccurrences() {
        return this.mOccurrences[0] + this.mOccurrences[1] + this.mOccurrences[2];
    }

    public int[] getOccurrencesArray() {
        return this.mOccurrences;
    }

    public void addWord(String word) {
        this.mWords.add(word);
        StringBuilder builder = new StringBuilder();
        for (String w : this.mWords) {
            builder.append(w).append(" ");
        }
        String newWord = builder.toString();
        this.mDistance = (int)new Levenshtein().distance(newWord, this.mLabel);
    }

    public int getWordsLength() {
        int l = 0;
        for (String w : this.mWords) {
            l += w.length();
        }
        return l;
    }

    public String toString() {
        return "Match [mLabel=" + this.mLabel + "]";
    }

    public static class Comparator
    implements java.util.Comparator<Match> {
        @Override
        public int compare(Match match, Match t1) {
            if (match.getWords().size() > t1.getWords().size()) {
                return -1;
            }
            if (match.getWords().size() < t1.getWords().size()) {
                return 1;
            }
            if (match.getDistance() < t1.getDistance()) {
                return -1;
            }
            if (match.getDistance() > t1.getDistance()) {
                return 1;
            }
            if (match.getOccurrences() > t1.getOccurrences()) {
                return -1;
            }
            if (match.getOccurrences() < t1.getOccurrences()) {
                return 1;
            }
            if (match.getLabel().length() > t1.getLabel().length()) {
                return -1;
            }
            if (match.getLabel().length() < t1.getLabel().length()) {
                return 1;
            }
            return 0;
        }
    }
}

