/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.systems;

import java.util.ArrayList;
import java.util.HashSet;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.systems.ASystem;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YODA
extends ASystem {
    Logger log = LoggerFactory.getLogger(YODA.class);
    private static final long YODAY_WAIT_TIME = 1000L;
    private long lastCall = 0L;
    private String url = "http://yodaqa.felk.cvut.cz:4567/q";

    @Override
    public String name() {
        return "yoda";
    }

    @Override
    public void search(IQuestion question, String language) throws Exception {
        String finished;
        if (!question.getLanguageToQuestion().containsKey(language)) {
            return;
        }
        String questionString = (String)question.getLanguageToQuestion().get(language);
        this.log.debug(this.getClass().getSimpleName() + ": " + questionString);
        long timeToWait = this.lastCall + 1000L - System.currentTimeMillis();
        if (timeToWait > 0L) {
            Thread.sleep(timeToWait);
        }
        this.lastCall = System.currentTimeMillis();
        HashSet<String> result = new HashSet<String>();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.timeout).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        HttpPost httppost = new HttpPost(this.url);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("text", questionString));
        if (this.setLangPar) {
            params.add(new BasicNameValuePair("lang", language));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Consts.UTF_8);
        httppost.setEntity((HttpEntity)entity);
        HttpResponse response = client.execute((HttpUriRequest)httppost);
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new Exception("YODA Server could not answer due to: " + response.getStatusLine());
        }
        JSONParser parser = new JSONParser();
        JSONObject idjson = (JSONObject)parser.parse(this.responseparser.responseToString(response));
        String id = idjson.get((Object)"id").toString();
        HttpGet questionpost = new HttpGet(this.url + "/" + id);
        do {
            Thread.sleep(50L);
            HttpResponse questionresponse = client.execute((HttpUriRequest)questionpost);
            JSONObject responsejson = (JSONObject)parser.parse(this.responseparser.responseToString(questionresponse));
            finished = responsejson.get((Object)"finished").toString();
            if (finished.equals("true")) {
                JSONArray answer = (JSONArray)responsejson.get((Object)"answers");
                for (int j = 0; j < answer.size(); ++j) {
                    JSONObject answerj = (JSONObject)answer.get(j);
                    String textj = answerj.get((Object)"text").toString();
                    String confj = answerj.get((Object)"confidence").toString();
                    if (!((double)Float.parseFloat(confj) > 0.7)) continue;
                    result.add(textj);
                }
            } else {
                EntityUtils.consume((HttpEntity)questionresponse.getEntity());
            }
        } while (finished.equals("false"));
        question.setGoldenAnswers(result);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

