/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.systems;

import java.net.URI;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.systems.ASystem;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class START
extends ASystem {
    Logger log = LoggerFactory.getLogger(START.class);

    @Override
    public String name() {
        return "start";
    }

    @Override
    public void search(IQuestion question, String language) throws Exception {
        URI uri;
        HttpGet httpget;
        HttpResponse response;
        if (!question.getLanguageToQuestion().containsKey(language)) {
            return;
        }
        String questionString = (String)question.getLanguageToQuestion().get(language);
        this.log.debug(this.getClass().getSimpleName() + ": " + questionString);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.timeout).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        URIBuilder builder = new URIBuilder().setScheme("http").setHost("start.csail.mit.edu").setPath("/justanswer.php").setParameter("query", questionString);
        if (this.setLangPar) {
            builder = builder.setParameter("lang", language);
        }
        if ((response = client.execute((HttpUriRequest)(httpget = new HttpGet(uri = builder.build())))).getStatusLine().getStatusCode() >= 400) {
            throw new Exception("START Server could not answer due to: " + response.getStatusLine());
        }
        Document doc = Jsoup.parse((String)this.responseparser.responseToString(response));
        System.out.println(doc.select("span[type=reply]").text());
    }
}

