/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.systems;

import java.net.URI;
import java.util.HashSet;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.systems.ASystem;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SINA
extends ASystem {
    Logger log = LoggerFactory.getLogger(SINA.class);

    @Override
    public String name() {
        return "sina";
    }

    @Override
    public void search(IQuestion question, String language) throws Exception {
        URI uri;
        HttpGet httpget;
        HttpResponse response;
        if (!question.getLanguageToQuestion().containsKey(language)) {
            return;
        }
        String questionString = (String)question.getLanguageToQuestion().get(language);
        this.log.debug(this.getClass().getSimpleName() + ": " + questionString);
        HashSet<String> resultSet = new HashSet<String>();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.timeout).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        URIBuilder builder = new URIBuilder().setScheme("http").setHost("sina.aksw.org").setPath("/api/rest/search").setParameter("q", questionString);
        if (this.setLangPar) {
            builder = builder.setParameter("lang", language);
        }
        if ((response = client.execute((HttpUriRequest)(httpget = new HttpGet(uri = builder.build())))).getStatusLine().getStatusCode() >= 400) {
            throw new Exception("SINA Server could not answer due to: " + response.getStatusLine());
        }
        JSONParser parser = new JSONParser();
        String responseString = this.responseparser.responseToString(response);
        JSONArray answerjson = (JSONArray)parser.parse(responseString);
        for (int i = 0; i < answerjson.size(); ++i) {
            JSONObject answer = (JSONObject)answerjson.get(i);
            resultSet.add((String)answer.get((Object)"URI_PARAM"));
        }
        question.setGoldenAnswers(resultSet);
        uri = new URIBuilder().setScheme("http").setHost("sina.aksw.org").setPath("/api/rest/search").setParameter("q", questionString).setParameter("content", "sparql").build();
        httpget = new HttpGet(uri);
        response = client.execute((HttpUriRequest)httpget);
        responseString = this.responseparser.responseToString(response);
        answerjson = (JSONArray)parser.parse(responseString);
        if (answerjson.size() > 0) {
            JSONObject sparqlQuery = (JSONObject)answerjson.get(0);
            question.setSparqlQuery((String)sparqlQuery.get((Object)"SPARQL_PARAM"));
        }
    }
}

