/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.systems;

import java.util.HashSet;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.systems.ASystem;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKBQA
extends ASystem {
    Logger log = LoggerFactory.getLogger(OKBQA.class);
    private static final String CONTROLLER_URI = "http://ws.okbqa.org:7042/cm";
    private static final String TGM_URI = "http://ws.okbqa.org:1515/templategeneration/rocknrole";
    private static final String KB_URI2 = "http://dbpedia.org/sparql";
    private static final String QGM_URI = "http://ws.okbqa.org:38401/queries";
    private static final String AGM_URI = "http://ws.okbqa.org:7745/agm";
    private static final String DM_URI = "http://ws.okbqa.org:2357/agdistis/run";
    private JSONObject conf;

    public OKBQA() {
        this.createJSONConf();
    }

    private String execute(String jsonInput) throws Exception {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.timeout).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        HttpPost httppost = new HttpPost(CONTROLLER_URI);
        StringEntity entity = new StringEntity(jsonInput);
        httppost.setEntity((HttpEntity)entity);
        HttpResponse response = client.execute((HttpUriRequest)httppost);
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new Exception("OKBQA Server could not answer due to: " + response.getStatusLine());
        }
        return this.responseparser.responseToString(response);
    }

    @Override
    public void search(IQuestion question, String language) throws Exception {
        if (!question.getLanguageToQuestion().containsKey(language)) {
            return;
        }
        String questionString = (String)question.getLanguageToQuestion().get(language);
        this.log.debug(this.getClass().getSimpleName() + ": " + questionString);
        HashSet<String> answerSet = new HashSet<String>();
        question.setGoldenAnswers(answerSet);
        String responseString = this.execute(this.createInputJSON(questionString, language));
        JSONObject obj = new JSONObject(responseString);
        JSONArray results = obj.getJSONArray("result");
        for (int i = 0; i < results.length(); ++i) {
            JSONObject result = results.getJSONObject(i);
            String answerString = result.getString("answer");
            answerSet.add(answerString);
        }
        JSONArray logs = obj.getJSONArray("log");
        for (int i = 0; i < logs.length(); ++i) {
            JSONObject log = logs.getJSONObject(i);
            if (!log.getString("1. module").equals("QGM") || !log.has("4. output")) continue;
            try {
                JSONArray qout = log.getJSONArray("4. output");
                if (qout.length() <= 0 || !qout.getJSONObject(0).has("query")) continue;
                String queryString = qout.getJSONObject(0).getString("query");
                question.setSparqlQuery(queryString);
                continue;
            }
            catch (JSONException e) {
                return;
            }
        }
        question.setGoldenAnswers(answerSet);
    }

    @Override
    public String name() {
        return "okbqa";
    }

    private String createInputJSON(String questionString, String language) {
        JSONObject json = new JSONObject();
        JSONObject input = new JSONObject();
        input.put("language", (Object)language);
        input.put("string", (Object)questionString);
        json.put("input", (Object)input);
        json.put("conf", (Object)this.conf);
        json.put("timelimit", (Object)"10000");
        return json.toString();
    }

    private void createJSONConf() {
        this.conf = new JSONObject();
        JSONArray sequence = new JSONArray();
        sequence.put(0, (Object)"TGM");
        sequence.put(1, (Object)"DM");
        sequence.put(2, (Object)"QGM");
        sequence.put(3, (Object)"AGM");
        this.conf.put("sequence", (Object)sequence);
        JSONObject address = new JSONObject();
        JSONArray kbAddress = new JSONArray();
        JSONArray kbAddressURIs = new JSONArray();
        kbAddressURIs.put(0, (Object)KB_URI2);
        kbAddressURIs.put(1, (Object)"");
        kbAddress.put((Object)kbAddressURIs);
        JSONArray tgmAddress = new JSONArray();
        tgmAddress.put((Object)TGM_URI);
        JSONArray dmAddress = new JSONArray();
        dmAddress.put((Object)DM_URI);
        JSONArray qgmAddress = new JSONArray();
        qgmAddress.put((Object)QGM_URI);
        JSONArray agmAddress = new JSONArray();
        agmAddress.put((Object)AGM_URI);
        address.put("KB", (Object)kbAddress);
        address.put("TGM", (Object)tgmAddress);
        address.put("DM", (Object)dmAddress);
        address.put("QGM", (Object)qgmAddress);
        address.put("AGM", (Object)agmAddress);
        this.conf.put("address", (Object)address);
    }
}

