/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.systems;

import java.net.URI;
import java.util.Base64;
import java.util.HashSet;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.systems.ASystem;
import org.apache.commons.codec.Charsets;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HAWK
extends ASystem {
    Logger log = LoggerFactory.getLogger(HAWK.class);
    private Base64.Decoder based64Decoder = Base64.getDecoder();

    @Override
    public String name() {
        return "hawk";
    }

    @Override
    public void search(IQuestion question, String language) throws Exception {
        URI iduri;
        HttpGet httpget;
        HttpResponse idresponse;
        if (!question.getLanguageToQuestion().containsKey(language)) {
            return;
        }
        String questionString = (String)question.getLanguageToQuestion().get(language);
        this.log.debug(this.getClass().getSimpleName() + ": " + questionString);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.timeout).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        URIBuilder builder = new URIBuilder().setScheme("http").setHost("139.18.2.164:8181").setPath("/search").setParameter("q", questionString);
        if (this.setLangPar) {
            builder = builder.setParameter("lang", language);
        }
        if ((idresponse = client.execute((HttpUriRequest)(httpget = new HttpGet(iduri = builder.build())))).getStatusLine().getStatusCode() >= 400) {
            throw new Exception("HAWK Server (ID) could not answer due to: " + idresponse.getStatusLine());
        }
        String id = this.responseparser.responseToString(idresponse);
        JSONParser parser = new JSONParser();
        URI quri = new URIBuilder().setScheme("http").setHost("139.18.2.164:8181").setPath("/status").setParameter("UUID", id.substring(1, id.length() - 2)).build();
        int j = 0;
        do {
            Thread.sleep(50L);
            HttpGet questionpost = new HttpGet(quri);
            HttpResponse questionresponse = client.execute((HttpUriRequest)questionpost);
            if (questionresponse.getStatusLine().getStatusCode() >= 400) {
                throw new Exception("HAWK Server (Question) could not answer due to: " + questionresponse.getStatusLine());
            }
            JSONObject responsejson = (JSONObject)parser.parse(this.responseparser.responseToString(questionresponse));
            if (!responsejson.containsKey((Object)"answer")) continue;
            JSONArray answerlist = (JSONArray)responsejson.get((Object)"answer");
            HashSet<String> result = new HashSet<String>();
            for (int i = 0; i < answerlist.size(); ++i) {
                JSONObject answer = (JSONObject)answerlist.get(i);
                result.add(answer.get((Object)"URI").toString());
            }
            question.setGoldenAnswers(result);
            if (!responsejson.containsKey((Object)"final_sparql_base64")) continue;
            String sparqlQuery = responsejson.get((Object)"final_sparql_base64").toString();
            sparqlQuery = new String(this.based64Decoder.decode(sparqlQuery), Charsets.UTF_8);
            question.setSparqlQuery(sparqlQuery);
        } while (++j < 500);
    }
}

