/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.webservice;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletResponse;
import org.aksw.hawk.controller.AbstractPipeline;
import org.aksw.hawk.controller.PipelineStanford;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.webservice.AsyncSearchExecutor;
import org.aksw.hawk.webservice.NounCombinationWeb;
import org.aksw.hawk.webservice.SearchExecutor;
import org.aksw.hawk.webservice.SearchIdException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;
import org.springframework.util.SimpleIdGenerator;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Component
@SpringBootApplication
@EnableAsync
public class WebController {
    private Logger log = LoggerFactory.getLogger(WebController.class);
    private PipelineStanford pipeline = new PipelineStanford();
    private NounCombinationWeb nouns = new NounCombinationWeb(this.pipeline.getStanfordConnector());
    private SimpleIdGenerator IdGenerator = new SimpleIdGenerator();
    private HashMap<UUID, Future<HAWKQuestion>> runningProcesses = Maps.newHashMap();
    private HashMap<UUID, HAWKQuestion> UuidQuestionMap = Maps.newHashMap();
    @Autowired
    @Qualifier(value="asyncSearchExecutor")
    private AsyncSearchExecutor asyncSearchExecutor;
    @Qualifier(value="SearchExecutor")
    private SearchExecutor searchExecutor = new SearchExecutor();

    public WebController() {
        this.searchExecutor.setPipeline((AbstractPipeline)this.pipeline);
    }

    @RequestMapping(value={"/simple-search"})
    public String simplesearch(@RequestParam(value="query") String question, HttpServletResponse response) {
        this.log.debug("Received question = " + question);
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers", "x-requested-with");
        return this.searchExecutor.runPipeline(question);
    }

    @RequestMapping(value={"/search"})
    public UUID search(@RequestParam(value="q") String question, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers", "x-requested-with");
        HAWKQuestion q = new HAWKQuestion();
        q.getLanguageToQuestion().put("en", question);
        q.setUUID(this.IdGenerator.generateId());
        Future report = this.asyncSearchExecutor.search(q);
        this.runningProcesses.put(q.getUUID(), report);
        this.UuidQuestionMap.put(q.getUUID(), q);
        return q.getUUID();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/status"})
    public String status(@RequestParam(value="UUID") UUID UUID2, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers", "x-requested-with");
        if (this.runningProcesses.containsKey(UUID2)) {
            Future q = (Future)this.runningProcesses.get(UUID2);
            if (!q.isDone()) return ((HAWKQuestion)this.UuidQuestionMap.get(UUID2)).getJSONStatus();
            this.runningProcesses.remove(UUID2);
            try {
                return ((HAWKQuestion)q.get()).getJSONStatus();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                throw new SearchIdException(UUID2);
            }
        } else {
            if (!this.UuidQuestionMap.containsKey(UUID2)) throw new SearchIdException(UUID2);
            return ((HAWKQuestion)this.UuidQuestionMap.get(UUID2)).getJSONStatus();
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/nounphrase"})
    public String nounphraseGET(@RequestParam(value="q") String question) {
        return this.nouns.stringToNif(question);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/nounphrase"})
    public String nounphrasePOST(@RequestBody String input) {
        return this.nouns.nifToAnswerNif(input);
    }

    public static void main(String[] args) {
        SpringApplication.run(WebController.class, (String[])args);
    }
}

