/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.qa.commons.sparql.SPARQL;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnswerBox {
    static Logger log = LoggerFactory.getLogger(AnswerBox.class);
    private static QueryExecutionFactory qef;

    public static JSONObject buildAnswerBoxFeatures(String uri) {
        JSONObject document = new JSONObject();
        document.put((Object)"URI", (Object)new JsonString(uri));
        HashSet set = Sets.newHashSet();
        try {
            String query = "select ?thumbnail ?abstract ?comment ?labelwhere {<" + uri + "> <http://dbpedia.org/ontology/thumbnail> ?thumbnail;" + "<http://dbpedia.org/ontology/abstract> ?abstract;" + "<http://www.w3.org/2000/01/rdf-schema#label> ?label;" + "<http://www.w3.org/2000/01/rdf-schema#comment> ?comment." + "FILTER(langMatches(lang(?abstract), \"EN\") &&" + "          langMatches(lang(?label), \"EN\") &&" + "          langMatches(lang(?comment), \"EN\"))" + "}";
            QueryExecution qe = qef.createQueryExecution(query);
            if (qe != null && query.toString() != null) {
                ResultSet results = qe.execSelect();
                while (results.hasNext()) {
                    QuerySolution next = results.next();
                    RDFNode thumbnail = next.get("thumbnail");
                    RDFNode abstractLiteral = next.get("abstract");
                    RDFNode commentLiteral = next.get("comment");
                    RDFNode labelLiteral = next.get("label");
                    if (thumbnail != null) {
                        document.put((Object)"thumbnail", (Object)new JsonString(thumbnail.asResource().getURI()));
                    }
                    if (abstractLiteral != null) {
                        document.put((Object)"abstract", (Object)new JsonString(abstractLiteral.asLiteral().getString()));
                    }
                    if (commentLiteral != null) {
                        document.put((Object)"comment", (Object)new JsonString(commentLiteral.asLiteral().getString()));
                    }
                    if (labelLiteral == null) continue;
                    document.put((Object)"label", (Object)new JsonString(labelLiteral.asLiteral().getString()));
                }
            }
        }
        catch (Exception e) {
            log.error("Cannot ask DBpedia for verbose description of " + uri, (Throwable)e);
        }
        return document;
    }

    static {
        SPARQL sparql = new SPARQL();
        qef = sparql.qef;
    }
}

