/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.spotter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.aksw.qa.annotation.spotter.ASpotter;
import org.aksw.qa.annotation.spotter.Fox;
import org.aksw.qa.annotation.spotter.Spotlight;
import org.aksw.qa.annotation.spotter.TagMe;
import org.aksw.qa.commons.datastructure.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSpotter
extends ASpotter {
    private static final Logger logger = LoggerFactory.getLogger(MultiSpotter.class);
    private List<ASpotter> spotters;
    private Map<String, List<Entity>> totalResult;

    public MultiSpotter(ASpotter ... spotters) {
        this.spotters = Arrays.asList(spotters);
    }

    public Map<String, List<Entity>> getEntities(String question) {
        this.totalResult = Maps.newConcurrentMap();
        ExecutorService tp = Executors.newFixedThreadPool(this.spotters.size());
        ExecutorCompletionService ecs = new ExecutorCompletionService(tp);
        for (ASpotter spotter : this.spotters) {
            tp.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        tp.shutdown();
        try {
            tp.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.totalResult;
    }

    private synchronized void mergeResults(Map<String, List<Entity>> result) {
        for (Map.Entry<String, List<Entity>> entry : result.entrySet()) {
            String lang = entry.getKey();
            List<Entity> newEntities = entry.getValue();
            List existingEntities = (List)this.totalResult.get(lang);
            if (existingEntities != null) {
                ArrayList tmp = Lists.newArrayList();
                for (Entity entity1 : newEntities) {
                    boolean add = true;
                    for (Entity entity2 : existingEntities) {
                        if (!entity1.getLabel().equals(entity2.getLabel())) continue;
                        add = false;
                        entity2.getUris().addAll(entity1.getUris());
                        break;
                    }
                    if (!add) continue;
                    tmp.add(entity1);
                }
                existingEntities.addAll(tmp);
                continue;
            }
            this.totalResult.put(lang, newEntities);
        }
    }

    public static void main(String[] args) throws Exception {
        String question = "Which building owned by the crown overlook the North Sea?";
        Fox fox = new Fox();
        System.out.println(fox.getEntities(question));
        TagMe tagMe = new TagMe();
        System.out.println(tagMe.getEntities(question));
        Spotlight spot = new Spotlight();
        System.out.println(spot.getEntities(question));
        MultiSpotter multiSpotter = new MultiSpotter(new ASpotter[]{fox, tagMe, spot});
        System.out.println(multiSpotter.getEntities(question));
    }

    static /* synthetic */ void access$000(MultiSpotter x0, Map x1) {
        x0.mergeResults(x1);
    }
}

