/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.ranking;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.hawk.datastructures.Answer;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.nlp.MutableTree;
import org.aksw.hawk.nlp.MutableTreeNode;
import org.aksw.hawk.nlp.MutableTreeNodeIterator;
import org.aksw.hawk.ranking.Ranking;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementWalker;

/*
 * Exception performing whole class analysis ignored.
 */
public class TierRanker
implements Ranking {
    private MutableTree tree = new MutableTree();
    private MutableTreeNodeIterator it;

    public TierRanker() {
    }

    public TierRanker(MutableTree tree) {
        this.init(tree);
    }

    public void init(MutableTree tree) {
        this.tree = tree;
        this.it = new MutableTreeNodeIterator(this.tree.getRoot());
    }

    protected double getScore(Query query) {
        double ret = 0.0;
        Set clause = TierRanker.queryToNodeList((Query)query);
        while (this.it.hasNext()) {
            MutableTreeNode cur = this.it.next();
            int nodeTier = this.it.getTier();
            double curScore = TierRanker.getScoreForNode((MutableTreeNode)cur, (int)nodeTier, (Set)clause);
            ret += curScore;
        }
        this.it.reset();
        return ret;
    }

    protected static double getScoreForNode(MutableTreeNode node, int nodeTier, Set<String> clause) {
        double ret = 0.0;
        if (clause.contains(node.label)) {
            ret = 1.0;
        }
        double tier = 1.0 / Math.pow(2.0, nodeTier);
        return ret * tier;
    }

    private static Set<String> queryToNodeList(Query q) {
        HashSet<String> subjects = new HashSet<String>();
        ElementWalker.walk((Element)q.getQueryPattern(), (ElementVisitor)new /* Unavailable Anonymous Inner Class!! */);
        return subjects;
    }

    private static String getString(Node n) {
        if (n.isURI()) {
            return n.getURI();
        }
        if (n.isVariable()) {
            return n.toString();
        }
        if (n.isBlank()) {
            return n.getBlankNodeLabel();
        }
        if (n.isLiteral()) {
            return n.toString(false);
        }
        return "";
    }

    protected static String resolvedClause(Query q) {
        Map map = q.getPrefixMapping().getNsPrefixMap();
        for (String key : map.keySet()) {
            q.getPrefixMapping().removeNsPrefix(key);
        }
        return q.getQueryPattern().toString();
    }

    public List<Answer> rank(List<Answer> answers, HAWKQuestion q) {
        this.init(q.getTree());
        for (Answer answer : answers) {
            double rank = this.getScore(QueryFactory.create((String)answer.queryString));
            System.out.println(answer.queryString + " ranked with score: " + rank);
            answer.score = rank;
        }
        Collections.sort(answers);
        Collections.reverse(answers);
        return answers;
    }

    static /* synthetic */ String access$000(Node x0) {
        return TierRanker.getString((Node)x0);
    }
}

