/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.ranking;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.hawk.datastructures.Answer;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.ranking.Ranking;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.qald.QALD4_EvaluationUtils;

public class OptimalRanker
implements Ranking {
    public List<Answer> rank(List<Answer> answers, HAWKQuestion q) {
        HashMap buckets = Maps.newHashMap();
        for (Answer answer : answers) {
            Set answerSet = answer.answerSet;
            double d = QALD4_EvaluationUtils.fMeasure((Set)answerSet, (IQuestion)q);
            if (!(d > 0.0)) continue;
            buckets.put(answer, d);
        }
        LinkedList tmplist = new LinkedList(buckets.entrySet());
        Collections.sort(tmplist, new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<Answer> list = new ArrayList<Answer>();
        for (Map.Entry entry : tmplist) {
            list.add((Answer)entry.getKey());
        }
        return list;
    }
}

