/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.ranking;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aksw.hawk.datastructures.Answer;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.ranking.Ranking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketRanker
implements Ranking {
    static Logger log = LoggerFactory.getLogger(BucketRanker.class);

    public List<Answer> rank(List<Answer> answers, HAWKQuestion q) {
        HashMap buckets = Maps.newHashMap();
        for (Answer answer : answers) {
            if (buckets.containsKey(answer)) {
                int count = (Integer)buckets.get(answer) + 1;
                buckets.put(answer, count);
                continue;
            }
            buckets.put(answer, 1);
        }
        LinkedList tmplist = new LinkedList(buckets.entrySet());
        Collections.sort(tmplist, new /* Unavailable Anonymous Inner Class!! */);
        Collections.reverse(tmplist);
        ArrayList<Answer> list = new ArrayList<Answer>();
        for (Map.Entry entry : tmplist) {
            Answer answer = (Answer)entry.getKey();
            answer.score = (double)((Integer)entry.getValue());
            list.add(answer);
        }
        return list;
    }
}

