/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.querybuilding;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.nlp.MutableTreeNode;
import org.aksw.hawk.querybuilding.SPARQLQueryBuilder;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.qa.commons.sparql.SPARQLQuery;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveSparqlQueryBuilder {
    Logger log = LoggerFactory.getLogger(RecursiveSparqlQueryBuilder.class);

    public Set<SPARQLQuery> start(SPARQLQueryBuilder sparqlQueryBuilder, HAWKQuestion q) {
        SPARQLQuery initialQuery = new SPARQLQuery();
        initialQuery.isASKQuery(q.getIsClassifiedAsASKQuery().booleanValue());
        HashSet returnSet = Sets.newHashSet((Object[])new SPARQLQuery[]{initialQuery});
        HashSet variableSet = Sets.newHashSet((Object[])new String[]{"?proj", "?const"});
        try {
            MutableTreeNode tmp = q.getTree().getRoot();
            this.recursion((Set)returnSet, (Set)variableSet, tmp);
        }
        catch (CloneNotSupportedException e) {
            this.log.error("Exception while recursion", (Throwable)e);
        }
        return returnSet;
    }

    private void recursion(Set<SPARQLQuery> returnSet, Set<String> variableSet, MutableTreeNode tmp) throws CloneNotSupportedException {
        SPARQLQuery variant3;
        SPARQLQuery variant2;
        SPARQLQuery variant1;
        HashSet sb = Sets.newHashSet();
        if (!tmp.getAnnotations().isEmpty()) {
            for (SPARQLQuery sPARQLQuery : returnSet) {
                for (String anno : tmp.getAnnotations()) {
                    if (tmp.posTag.matches("VB(.)*")) {
                        SPARQLQuery variant12 = (SPARQLQuery)sPARQLQuery.clone();
                        variant12.addConstraint("?proj <" + anno + "> ?const.");
                        SPARQLQuery variant22 = (SPARQLQuery)sPARQLQuery.clone();
                        variant22.addConstraint("?const <" + anno + "> ?proj.");
                        SPARQLQuery variant32 = (SPARQLQuery)sPARQLQuery.clone();
                        sb.add(variant12);
                        sb.add(variant22);
                        sb.add(variant32);
                        continue;
                    }
                    if (tmp.posTag.matches("NN(.)*|WRB")) {
                        SPARQLQuery variant23 = (SPARQLQuery)sPARQLQuery.clone();
                        variant23.addConstraint("?const <" + anno + "> ?proj.");
                        SPARQLQuery variant33 = (SPARQLQuery)sPARQLQuery.clone();
                        variant33.addConstraint("?const a <" + anno + ">.");
                        SPARQLQuery variant4 = (SPARQLQuery)sPARQLQuery.clone();
                        variant4.addConstraint("?proj a <" + anno + ">.");
                        SPARQLQuery variant5 = (SPARQLQuery)sPARQLQuery.clone();
                        variant5.addFilterOverAbstractsContraint("?proj", tmp.label);
                        SPARQLQuery variant6 = (SPARQLQuery)sPARQLQuery.clone();
                        variant6.addFilterOverAbstractsContraint("?const", tmp.label);
                        SPARQLQuery variant7 = (SPARQLQuery)sPARQLQuery.clone();
                        sb.add(variant23);
                        sb.add(variant33);
                        sb.add(variant4);
                        sb.add(variant5);
                        sb.add(variant6);
                        sb.add(variant7);
                        continue;
                    }
                    if (tmp.posTag.matches("WP")) {
                        SPARQLQuery variant12 = (SPARQLQuery)sPARQLQuery.clone();
                        variant12.addConstraint("?const a <" + anno + ">.");
                        SPARQLQuery variant22 = (SPARQLQuery)sPARQLQuery.clone();
                        variant22.addConstraint("?proj a <" + anno + ">.");
                        SPARQLQuery variant32 = (SPARQLQuery)sPARQLQuery.clone();
                        sb.add(variant12);
                        sb.add(variant22);
                        sb.add(variant32);
                        continue;
                    }
                    this.log.error("Tmp: " + tmp.label + " pos: " + tmp.posTag);
                }
            }
        } else if (tmp.posTag.matches("CombinedNN|NNP(.)*|JJ|CD")) {
            for (SPARQLQuery sPARQLQuery : returnSet) {
                variant1 = (SPARQLQuery)sPARQLQuery.clone();
                variant1.addFilterOverAbstractsContraint("?proj", tmp.label);
                variant2 = (SPARQLQuery)sPARQLQuery.clone();
                variant2.addFilterOverAbstractsContraint("?const", tmp.label);
                variant3 = (SPARQLQuery)sPARQLQuery.clone();
                sb.add(variant1);
                sb.add(variant2);
                sb.add(variant3);
            }
        } else if (tmp.posTag.matches("VB(.)*")) {
            for (SPARQLQuery sPARQLQuery : returnSet) {
                variant1 = (SPARQLQuery)sPARQLQuery.clone();
                variant1.addFilterOverAbstractsContraint("?proj", tmp.label);
                variant2 = (SPARQLQuery)sPARQLQuery.clone();
                variant2.addFilterOverAbstractsContraint("?const", tmp.label);
                variant3 = (SPARQLQuery)sPARQLQuery.clone();
                sb.add(variant1);
                sb.add(variant2);
                sb.add(variant3);
            }
        } else if (tmp.posTag.matches("ADD")) {
            Set origLabels = this.getOrigLabel(tmp.label);
            for (SPARQLQuery query : returnSet) {
                SPARQLQuery variant13 = (SPARQLQuery)query.clone();
                variant13.addConstraint("?proj ?pbridge <" + tmp.label + ">.");
                variant3 = (SPARQLQuery)query.clone();
                sb.add(variant13);
                sb.add(variant3);
                for (String origLabel : origLabels) {
                    SPARQLQuery variant4 = (SPARQLQuery)query.clone();
                    variant4.addFilterOverAbstractsContraint("?proj", origLabel);
                    SPARQLQuery variant5 = (SPARQLQuery)query.clone();
                    variant5.addFilterOverAbstractsContraint("?const", origLabel);
                    sb.add(variant4);
                    sb.add(variant5);
                }
            }
        } else if (tmp.posTag.matches("NN|NNS")) {
            for (SPARQLQuery sPARQLQuery : returnSet) {
                variant1 = (SPARQLQuery)sPARQLQuery.clone();
                variant1.addFilterOverAbstractsContraint("?proj", tmp.label);
                variant2 = (SPARQLQuery)sPARQLQuery.clone();
                variant2.addFilterOverAbstractsContraint("?const", tmp.label);
                variant3 = (SPARQLQuery)sPARQLQuery.clone();
                sb.add(variant1);
                sb.add(variant2);
                sb.add(variant3);
            }
        } else if (tmp.posTag.matches("WP")) {
            sb.addAll(returnSet);
        } else {
            this.log.error("Tmp: " + tmp.label + " pos: " + tmp.posTag);
            sb.addAll(returnSet);
        }
        returnSet.clear();
        returnSet.addAll(sb);
        for (MutableTreeNode mutableTreeNode : tmp.getChildren()) {
            this.log.debug("Recursion started for :" + mutableTreeNode);
            this.recursion(returnSet, variableSet, mutableTreeNode);
        }
    }

    private Set<String> getOrigLabel(String label) {
        HashSet resultset = Sets.newHashSet();
        String query = "SELECT str(?proj)  WHERE { <" + label + "> <http://www.w3.org/2000/01/rdf-schema#label> ?proj. FILTER(langMatches( lang(?proj), \"EN\" ))}";
        try {
            QueryExecutionFactoryHttp qef = new QueryExecutionFactoryHttp("http://139.18.2.164:3030/ds/sparql");
            QueryExecution qe = qef.createQueryExecution(query);
            if (qe != null) {
                this.log.debug(query.toString());
                ResultSet results = qe.execSelect();
                while (results.hasNext()) {
                    QuerySolution next = results.next();
                    String varName = (String)next.varNames().next();
                    resultset.add(next.get(varName).toString());
                }
            }
        }
        catch (Exception e) {
            this.log.error(query.toString(), (Throwable)e);
        }
        return resultset;
    }
}

