/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.pruner;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.pruner.ISPARQLQueryPruner;
import org.aksw.qa.commons.sparql.SPARQLQuery;

public class UnboundTriple
implements ISPARQLQueryPruner {
    private int maximalUnboundTriplePatterns = 1;

    public Set<SPARQLQuery> prune(Set<SPARQLQuery> queryStrings, HAWKQuestion q) {
        HashSet returnSet = Sets.newHashSet();
        for (SPARQLQuery sparqlQuery : queryStrings) {
            int numberOfUnboundTriplePattern = 0;
            String[] split = new String[3];
            for (String triple : sparqlQuery.constraintTriples) {
                split = triple.split(" ");
                if (!split[0].startsWith("?") || !split[1].startsWith("?") || !split[2].startsWith("?")) continue;
                ++numberOfUnboundTriplePattern;
            }
            if (numberOfUnboundTriplePattern > this.maximalUnboundTriplePatterns) continue;
            returnSet.add(sparqlQuery);
        }
        return returnSet;
    }
}

