/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.pruner;

import java.util.HashSet;
import java.util.Set;
import javax.xml.ws.http.HTTPException;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.pruner.BGPisConnected;
import org.aksw.hawk.pruner.ContainsProjVariable;
import org.aksw.hawk.pruner.ContainsTooManyNodesAsTextLookUp;
import org.aksw.hawk.pruner.CyclicTriple;
import org.aksw.hawk.pruner.HasBoundVariables;
import org.aksw.hawk.pruner.ISPARQLQueryPruner;
import org.aksw.hawk.pruner.NumberOfTypesPerVariable;
import org.aksw.hawk.pruner.PredicatesPerVariableEdge;
import org.aksw.hawk.pruner.TextFilterOverVariables;
import org.aksw.hawk.pruner.TypeMismatch;
import org.aksw.hawk.pruner.UnboundTriple;
import org.aksw.hawk.pruner.UnderDefinedQueries;
import org.aksw.hawk.pruner.disjointness.DisjointnessBasedQueryFilter;
import org.aksw.qa.commons.sparql.SPARQL;
import org.aksw.qa.commons.sparql.SPARQLQuery;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SPARQLQueryPruner
implements ISPARQLQueryPruner {
    private static Logger log = LoggerFactory.getLogger(SPARQLQueryPruner.class);
    private DisjointnessBasedQueryFilter disjointness;
    private BGPisConnected BGPisConnected;
    private CyclicTriple cyclicTriple;
    private HasBoundVariables hasBoundVariables;
    private TextFilterOverVariables textFilterOverVariables;
    private UnboundTriple unboundTriple;
    private UnderDefinedQueries underdefined;
    private PredicatesPerVariableEdge predicatesPerVariableEdge;
    private NumberOfTypesPerVariable numberOfTypesPerVariable;
    private ContainsProjVariable containsProjVariable;
    private ContainsTooManyNodesAsTextLookUp containsTooManyNodesAsTextLookUp;
    private TypeMismatch typemismatch;

    public SPARQLQueryPruner(SPARQL sparql) {
        this.disjointness = new DisjointnessBasedQueryFilter(sparql.qef);
        this.BGPisConnected = new BGPisConnected();
        this.cyclicTriple = new CyclicTriple();
        this.hasBoundVariables = new HasBoundVariables();
        this.textFilterOverVariables = new TextFilterOverVariables();
        this.unboundTriple = new UnboundTriple();
        this.underdefined = new UnderDefinedQueries();
        this.predicatesPerVariableEdge = new PredicatesPerVariableEdge();
        this.numberOfTypesPerVariable = new NumberOfTypesPerVariable();
        this.containsProjVariable = new ContainsProjVariable();
        this.containsTooManyNodesAsTextLookUp = new ContainsTooManyNodesAsTextLookUp();
        this.typemismatch = new TypeMismatch(sparql.qef);
    }

    public Set<SPARQLQuery> prune(Set<SPARQLQuery> queries, HAWKQuestion q) {
        Set returnedQueries = null;
        JSONArray document = new JSONArray();
        JSONObject tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"Number of Queries before pruning");
        tmp.put((Object)"value", (Object)queries.size());
        document.add((Object)tmp);
        returnedQueries = this.underdefined.prune(queries, q);
        tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"Underdefined pruned");
        tmp.put((Object)"value", (Object)(queries.size() - returnedQueries.size()));
        tmp.put((Object)"removedQueries", (Object)SPARQLQueryPruner.queries2json((Set)SPARQLQueryPruner.queriesDiff(queries, (Set)returnedQueries)));
        document.add((Object)tmp);
        queries = returnedQueries;
        returnedQueries = this.containsProjVariable.prune(queries, q);
        tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"SPARQL queries containing no project variable pruned");
        tmp.put((Object)"value", (Object)(queries.size() - returnedQueries.size()));
        tmp.put((Object)"removedQueries", (Object)SPARQLQueryPruner.queries2json((Set)SPARQLQueryPruner.queriesDiff((Set)queries, (Set)returnedQueries)));
        document.add((Object)tmp);
        queries = returnedQueries;
        returnedQueries = this.containsTooManyNodesAsTextLookUp.prune(queries, q);
        tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"SPARQL queries containing too many nodes as text lookup pruned");
        tmp.put((Object)"value", (Object)(queries.size() - returnedQueries.size()));
        tmp.put((Object)"removedQueries", (Object)SPARQLQueryPruner.queries2json((Set)SPARQLQueryPruner.queriesDiff((Set)queries, (Set)returnedQueries)));
        document.add((Object)tmp);
        queries = returnedQueries;
        returnedQueries = this.predicatesPerVariableEdge.prune(queries, q);
        tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"SPARQL queries with more than one predicate between the same variables pruned");
        tmp.put((Object)"value", (Object)(queries.size() - returnedQueries.size()));
        tmp.put((Object)"removedQueries", (Object)SPARQLQueryPruner.queries2json((Set)SPARQLQueryPruner.queriesDiff((Set)queries, (Set)returnedQueries)));
        document.add((Object)tmp);
        queries = returnedQueries;
        returnedQueries = this.numberOfTypesPerVariable.prune(queries, q);
        tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"SPARQL queries with more than one type per variable pruned");
        tmp.put((Object)"value", (Object)(queries.size() - returnedQueries.size()));
        tmp.put((Object)"removedQueries", (Object)SPARQLQueryPruner.queries2json((Set)SPARQLQueryPruner.queriesDiff((Set)queries, (Set)returnedQueries)));
        document.add((Object)tmp);
        queries = returnedQueries;
        returnedQueries = this.BGPisConnected.prune(queries, q);
        tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"SPARQL queries without connected BGP pruned");
        tmp.put((Object)"value", (Object)(queries.size() - returnedQueries.size()));
        tmp.put((Object)"removedQueries", (Object)SPARQLQueryPruner.queries2json((Set)SPARQLQueryPruner.queriesDiff((Set)queries, (Set)returnedQueries)));
        document.add((Object)tmp);
        queries = returnedQueries;
        returnedQueries = this.cyclicTriple.prune(queries, q);
        tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"SPARQL queries containing cycic triple pruned");
        tmp.put((Object)"value", (Object)(queries.size() - returnedQueries.size()));
        tmp.put((Object)"removedQueries", (Object)SPARQLQueryPruner.queries2json((Set)SPARQLQueryPruner.queriesDiff((Set)queries, (Set)returnedQueries)));
        document.add((Object)tmp);
        queries = returnedQueries;
        returnedQueries = this.hasBoundVariables.prune(queries, q);
        tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"SPARQL queries without bound variables pruned");
        tmp.put((Object)"value", (Object)(queries.size() - returnedQueries.size()));
        tmp.put((Object)"removedQueries", (Object)SPARQLQueryPruner.queries2json((Set)SPARQLQueryPruner.queriesDiff((Set)queries, (Set)returnedQueries)));
        document.add((Object)tmp);
        queries = returnedQueries;
        returnedQueries = this.textFilterOverVariables.prune(queries, q);
        tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"SPARQL queries without text filter over existing variables pruned");
        tmp.put((Object)"value", (Object)(queries.size() - returnedQueries.size()));
        tmp.put((Object)"removedQueries", (Object)SPARQLQueryPruner.queries2json((Set)SPARQLQueryPruner.queriesDiff((Set)queries, (Set)returnedQueries)));
        document.add((Object)tmp);
        queries = returnedQueries;
        returnedQueries = this.unboundTriple.prune(queries, q);
        tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"SPARQL queries with unbound triples pruned");
        tmp.put((Object)"value", (Object)(queries.size() - returnedQueries.size()));
        tmp.put((Object)"removedQueries", (Object)SPARQLQueryPruner.queries2json((Set)SPARQLQueryPruner.queriesDiff((Set)queries, (Set)returnedQueries)));
        document.add((Object)tmp);
        queries = returnedQueries;
        returnedQueries = this.typemismatch.prune(queries, q);
        tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"SPARQL queries with mismatching types pruned");
        tmp.put((Object)"value", (Object)(queries.size() - returnedQueries.size()));
        tmp.put((Object)"removedQueries", (Object)SPARQLQueryPruner.queries2json((Set)SPARQLQueryPruner.queriesDiff((Set)queries, (Set)returnedQueries)));
        document.add((Object)tmp);
        queries = returnedQueries;
        try {
            returnedQueries = this.disjointness.prune(queries, q);
            tmp = new JSONObject();
            tmp.put((Object)"label", (Object)"SPARQL queries with disjoint classes pruned");
            tmp.put((Object)"value", (Object)(queries.size() - returnedQueries.size()));
            tmp.put((Object)"removedQueries", (Object)SPARQLQueryPruner.queries2json((Set)SPARQLQueryPruner.queriesDiff((Set)queries, (Set)returnedQueries)));
            document.add((Object)tmp);
            queries = returnedQueries;
        }
        catch (HTTPException e) {
            log.error("Cannot prune based on disjointness due to unavailable endpoint", (Throwable)e);
        }
        tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"Number of Queries after really short pruning");
        tmp.put((Object)"value", (Object)queries.size());
        tmp.put((Object)"queries", (Object)SPARQLQueryPruner.queries2json((Set)queries));
        document.add((Object)tmp);
        q.setPruning_messages(document);
        log.debug(document.toJSONString());
        return queries;
    }

    private static Set<SPARQLQuery> queriesDiff(Set<SPARQLQuery> originalQueries, Set<SPARQLQuery> modifiedQueries) {
        HashSet<SPARQLQuery> result = new HashSet<SPARQLQuery>(originalQueries);
        result.removeAll(modifiedQueries);
        return result;
    }

    private static JSONArray queries2json(Set<SPARQLQuery> queries) {
        JSONArray jsonQueries = new JSONArray();
        for (SPARQLQuery query : queries) {
            JSONObject jsonQuery = new JSONObject();
            jsonQuery.put((Object)"query", (Object)query.toString());
            jsonQueries.add((Object)jsonQuery);
        }
        return jsonQueries;
    }
}

