/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.number;

import com.google.common.base.Joiner;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.aksw.hawk.controller.StanfordNLPConnector;
import org.aksw.hawk.number.IUnitLanguage;
import org.aksw.hawk.number.UnitController;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitEnglish
implements IUnitLanguage {
    private static Logger log = LoggerFactory.getLogger(UnitEnglish.class);
    HashMap<String, ImmutablePair<Double, String>> identifierToUnit;
    HashMap<String, Double> identifierToMultiplier;
    StanfordNLPConnector stanford;

    public UnitEnglish(StanfordNLPConnector stanford) {
        this.stanford = stanford;
        this.identifierToMultiplier = new HashMap();
        this.identifierToUnit = new HashMap();
        try {
            this.loadResource();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String convert(String q) {
        String out = "";
        if (q == null || q.isEmpty()) {
            return out;
        }
        if (q.toLowerCase().matches("(.*)(\\s)(one)([\\p{Punct}\\s])(.*)")) {
            Annotation document = this.stanford.runAnnotation(q);
            List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
            CoreMap sentenc = (CoreMap)sentences.get(0);
            SemanticGraph dependencies = (SemanticGraph)sentenc.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class);
            ArrayList parseForNumber = new ArrayList();
            ArrayList<String> outArray = new ArrayList<String>();
            boolean lastWasNumber = false;
            boolean numberContainsNmod = false;
            for (CoreLabel token : (List)sentenc.get(CoreAnnotations.TokensAnnotation.class)) {
                String ner = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                if (ner.toLowerCase().matches("number|duration|currency")) {
                    lastWasNumber = true;
                    IndexedWord depWord = dependencies.getNodeByIndex(token.index());
                    List depEdges = dependencies.getIncomingEdgesSorted(depWord);
                    numberContainsNmod = false;
                    for (SemanticGraphEdge it : depEdges) {
                        if (!it.getRelation().getShortName().toLowerCase().equals("nmod")) continue;
                        numberContainsNmod = true;
                        break;
                    }
                    outArray.add(token.word());
                    continue;
                }
                if (lastWasNumber && !numberContainsNmod) {
                    outArray.add(this.convertToBaseUnit(this.replaceNumerals(Joiner.on((String)" ").join(parseForNumber))));
                    outArray.add(token.word());
                    parseForNumber = new ArrayList();
                } else {
                    outArray.addAll(parseForNumber);
                    outArray.add(token.word());
                }
                lastWasNumber = false;
            }
            if (lastWasNumber && numberContainsNmod) {
                outArray.addAll(parseForNumber);
            }
            if (lastWasNumber && !numberContainsNmod) {
                outArray.add(this.replaceNumerals(Joiner.on((String)" ").join(parseForNumber)));
            }
            return Joiner.on((String)" ").join(outArray).replaceAll("(\\s+)(\\p{Punct})(\\s*)$", "$2");
        }
        return this.convertToBaseUnit(this.replaceNumerals(q)).trim();
    }

    private String replaceNumerals(String replaceThis) {
        ArrayList<String> split;
        if (replaceThis == null || replaceThis.isEmpty()) {
            return "";
        }
        log.debug("Replacing numerals on :" + replaceThis);
        String out = "";
        Double val = 1.0;
        Double lastNumber = 0.0;
        String withWhitespace = this.insertWhitespacebeforePunctuation(replaceThis);
        withWhitespace = withWhitespace.replaceAll("(\\p{Sc})(\\d+)", "$1 $2");
        ArrayList<String> cleaned = split = new ArrayList<String>(Arrays.asList(withWhitespace.split(" ")));
        boolean lastWasNumber = false;
        for (int i = 0; i < cleaned.size(); ++i) {
            String it = cleaned.get(i);
            Double parsedNumber = this.parseWord(it);
            if (parsedNumber == null && !lastWasNumber) {
                out = out + it + " ";
                continue;
            }
            if (parsedNumber == null && lastWasNumber) {
                if (it.equals("and")) continue;
                lastWasNumber = false;
                out = this.prettyAppendDouble(out, val) + it + " ";
                continue;
            }
            if (parsedNumber == null) continue;
            if (lastWasNumber) {
                val = parsedNumber < lastNumber ? Double.valueOf(val + parsedNumber) : Double.valueOf(val * parsedNumber);
                lastNumber = parsedNumber;
            } else {
                val = parsedNumber;
                lastNumber = parsedNumber;
                lastWasNumber = true;
            }
            if (i != cleaned.size() - 1) continue;
            out = this.prettyAppendDouble(out, val);
        }
        return out.trim();
    }

    private String convertToBaseUnit(String str) {
        String out = "";
        if (str == null || str.isEmpty()) {
            return out;
        }
        log.debug("converting base units for: " + str);
        String withWhitespace = this.insertWhitespacebeforePunctuation(str);
        ArrayList<String> split = new ArrayList<String>(Arrays.asList(withWhitespace.split(" ")));
        Double lastIt = null;
        for (String it : split) {
            if (lastIt != null) {
                out = this.identifierToUnit.containsKey(it) ? out + lastIt * (Double)((ImmutablePair)this.identifierToUnit.get(it)).getLeft() + " " + (String)((ImmutablePair)this.identifierToUnit.get(it)).getRight() + " " : this.prettyAppendDouble(out, lastIt) + it + " ";
                lastIt = null;
                continue;
            }
            try {
                lastIt = Double.parseDouble(it);
            }
            catch (NumberFormatException e) {
                out = out + it + " ";
            }
        }
        if (lastIt != null) {
            out = this.prettyAppendDouble(out, lastIt);
        }
        return out.replaceAll("(\\s+)(\\p{Punct})(\\s*)$", "$2");
    }

    private String insertWhitespacebeforePunctuation(String input) {
        return input.replaceAll("(\\w)([\\.?!])(\\s*)$", "$1 $2");
    }

    private String prettyAppendDouble(String out, Double val) {
        if (val == Math.floor(val) && !Double.isInfinite(val)) {
            return out + val.intValue() + " ";
        }
        DecimalFormat df = new DecimalFormat("#");
        return out + df.format(val);
    }

    private Double parseWord(String s) {
        Double out = null;
        try {
            out = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            out = (Double)this.identifierToMultiplier.get(s);
        }
        return out;
    }

    private void loadResource() throws IOException {
        log.debug("Loading number conversion rules for english");
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream input = classLoader.getResourceAsStream("unitconversion/englishIdentifierToUnit.txt");
        List data = UnitController.loadTabSplit((InputStream)input);
        if (data == null || data.isEmpty()) {
            return;
        }
        for (List line : data) {
            try {
                if (line.size() == 3) {
                    this.identifierToUnit.put(line.get(0), new ImmutablePair((Object)new Double((String)line.get(1)), line.get(2)));
                    continue;
                }
                this.identifierToMultiplier.put(line.get(0), new Double((String)line.get(1)));
            }
            catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException e) {
                log.debug("Could not parse line " + data.indexOf(line) + "from file " + input.toString());
            }
        }
    }

    public static void main(String[] args) {
        UnitEnglish ue = new UnitEnglish(null);
        String q = "$80 thousand and three hundred four";
        log.debug("Start conversion");
        System.out.println(ue.convert(q));
    }
}

