/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.nouncombination;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.nlp.MutableTree;
import org.aksw.hawk.nlp.MutableTreeNode;
import org.aksw.qa.commons.datastructure.Entity;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.ext.com.google.common.base.Joiner;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ResourceImpl;

abstract class ANounCombiner {
    ANounCombiner() {
    }

    protected abstract void combineNouns(HAWKQuestion var1);

    protected static void processTree(HAWKQuestion q) {
        MutableTree tree = q.getTree();
        Map entities = q.getLanguageToNounPhrases();
        List entityList = (List)entities.get("en");
        if (entityList == null) {
            return;
        }
        for (Entity it : entityList) {
            String combinedNN = Joiner.on((String)" ").join((Object[])((Resource)it.getUris().get(0)).getURI().replace("http://aksw.org/combinedNN/", "").split("_"));
            List<String> subsequence = Arrays.asList(combinedNN.split(" "));
            Stack<MutableTreeNode> stack = new Stack<MutableTreeNode>();
            stack.push(tree.getRoot());
            HashSet<MutableTreeNode> removables = new HashSet<MutableTreeNode>();
            while (!stack.isEmpty()) {
                MutableTreeNode thisNode = (MutableTreeNode)stack.pop();
                String label = thisNode.label;
                for (String iterator : subsequence) {
                    if (!label.equals(iterator) || thisNode.getLabelPosition() < it.getOffset() || thisNode.getLabelPosition() > it.getOffset() + subsequence.size()) continue;
                    thisNode.label = combinedNN;
                    thisNode.posTag = "CombinedNN";
                    if (thisNode.equals(tree.getRoot())) continue;
                    if (thisNode.parent.getLabel() == combinedNN) {
                        removables.add(thisNode);
                    }
                    for (MutableTreeNode pathNode : tree.getPathToRoot(thisNode)) {
                        if (pathNode.getLabel() != combinedNN) continue;
                        removables.add(thisNode);
                    }
                    List sameDepth = tree.getAllNodesWithDepth(thisNode.getDepth());
                    sameDepth.remove(thisNode);
                    for (MutableTreeNode sameDepthNode : sameDepth) {
                        if (sameDepthNode.getLabel() != combinedNN) continue;
                        removables.add(thisNode);
                    }
                }
                for (MutableTreeNode child : thisNode.getChildren()) {
                    stack.push(child);
                }
            }
            for (MutableTreeNode m : removables) {
                Log.debug(ANounCombiner.class, (String)("Removing node " + m.nodeNumber + ": " + m.toString()));
                tree.remove(m);
            }
            tree.updateNodeNumbers();
        }
    }

    protected static void setEntity(List<String> subsequence, HAWKQuestion q, int subsequenceStartOffset) {
        String combinedNN = Joiner.on((String)" ").join(subsequence);
        String combinedURI = "http://aksw.org/combinedNN/" + Joiner.on((String)"_").join(subsequence);
        Entity tmpEntity = new Entity();
        tmpEntity.setLabel(combinedNN);
        tmpEntity.setOffset(subsequenceStartOffset);
        tmpEntity.getUris().add(new ResourceImpl(combinedURI));
        List nounphrases = (List)q.getLanguageToNounPhrases().get("en");
        if (null == nounphrases) {
            nounphrases = Lists.newArrayList();
            q.getLanguageToNounPhrases().put("en", nounphrases);
        }
        nounphrases.add(tmpEntity);
    }
}

