/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.nlp;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.nlp.MutableTree;
import org.aksw.hawk.nlp.MutableTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableTreePruner {
    Logger log = LoggerFactory.getLogger(MutableTreePruner.class);

    public MutableTree prune(HAWKQuestion q) {
        this.log.debug(q.getTree().toString());
        this.removalRules(q);
        this.removalBasedOnDependencyLabels(q);
        this.applyInterrogativeRules(q);
        this.sortTree(q.getTree());
        this.log.debug(q.getTree().toString());
        return q.getTree();
    }

    private void sortTree(MutableTree tree) {
        LinkedList<MutableTreeNode> queue = new LinkedList<MutableTreeNode>();
        queue.add(tree.getRoot());
        while (!queue.isEmpty()) {
            MutableTreeNode tmp = (MutableTreeNode)queue.poll();
            Collections.sort(tmp.getChildren());
            queue.addAll(tmp.getChildren());
        }
    }

    private void removalBasedOnDependencyLabels(HAWKQuestion q) {
        for (String depLabel : Lists.newArrayList((Object[])new String[]{"auxpass", "aux"})) {
            this.inorderRemovalBasedOnDependencyLabels(q.getTree().getRoot(), q.getTree(), depLabel);
        }
    }

    private boolean inorderRemovalBasedOnDependencyLabels(MutableTreeNode node, MutableTree tree, String depLabel) {
        if (node.depLabel.matches(depLabel)) {
            tree.remove(node);
            return true;
        }
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            MutableTreeNode child = (MutableTreeNode)it.next();
            if (!this.inorderRemovalBasedOnDependencyLabels(child, tree, depLabel)) continue;
            it = node.getChildren().iterator();
        }
        return false;
    }

    private void applyInterrogativeRules(HAWKQuestion q) {
        MutableTreeNode root = q.getTree().getRoot();
        if (root.label.equals("Give")) {
            Iterator it = root.getChildren().iterator();
            while (it.hasNext()) {
                MutableTreeNode next = (MutableTreeNode)it.next();
                if (!next.label.equals("me")) continue;
                it.remove();
                q.getTree().remove(root);
            }
        }
        if (root.label.equals("List")) {
            q.getTree().remove(root);
        }
        if (root.label.equals("Give")) {
            q.getTree().remove(root);
        }
    }

    private void removalRules(HAWKQuestion q) {
        MutableTreeNode root = q.getTree().getRoot();
        for (String posTag : Lists.newArrayList((Object[])new String[]{".", "WDT", "POS", "WP\\$", "PRP\\$", "RB", "PRP", "DT", "IN", "PDT"})) {
            LinkedBlockingQueue queue = Queues.newLinkedBlockingQueue();
            queue.add(root);
            while (!queue.isEmpty()) {
                MutableTreeNode tmp = (MutableTreeNode)queue.poll();
                if (tmp.posTag.matches(posTag)) {
                    q.getTree().remove(tmp);
                }
                for (MutableTreeNode n : tmp.getChildren()) {
                    queue.add(n);
                }
            }
        }
    }
}

