/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.nlp;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MutableTreeNode
implements Comparable<MutableTreeNode>,
Serializable {
    private static final long serialVersionUID = 3684161169564127853L;
    public List<MutableTreeNode> children = new ArrayList();
    private boolean used = false;
    public MutableTreeNode parent;
    public int nodeNumber;
    public String depLabel;
    public String label;
    public String posTag;
    public String lemma;
    private List<String> annotations = Lists.newArrayList();
    private int depth;
    private int labelPosition;

    public MutableTreeNode() {
    }

    public MutableTreeNode hardcopy(MutableTreeNode parent) {
        MutableTreeNode node = new MutableTreeNode(this.label, this.posTag, this.depLabel, parent, this.nodeNumber, this.lemma, this.labelPosition);
        node.annotations = new ArrayList(this.annotations);
        node.used = this.used;
        for (MutableTreeNode it : this.children) {
            node.children.add(it.hardcopy(node));
        }
        return node;
    }

    public List<MutableTreeNode> subNodes() {
        ArrayList<MutableTreeNode> out = new ArrayList<MutableTreeNode>();
        out.add(this);
        if (this.getChildren().isEmpty()) {
            return out;
        }
        for (MutableTreeNode it : this.getChildren()) {
            out.addAll(it.subNodes());
        }
        return out;
    }

    public MutableTreeNode(String label, String posTag, String depLabel, MutableTreeNode parent, int i, String lemma) {
        this.label = label;
        this.posTag = posTag;
        this.parent = parent;
        this.depLabel = depLabel;
        this.nodeNumber = i;
        this.lemma = lemma;
        this.depth = parent != null ? parent.getDepth() + 1 : 0;
    }

    public MutableTreeNode(String label, String posTag, String depLabel, MutableTreeNode parent, int i, String lemma, int labelPosition) {
        this.label = label;
        this.posTag = posTag;
        this.parent = parent;
        this.depLabel = depLabel;
        this.nodeNumber = i;
        this.lemma = lemma;
        this.depth = parent != null ? parent.getDepth() + 1 : 0;
        this.setLabelPosition(labelPosition);
    }

    public void addChild(MutableTreeNode newNode) {
        this.children.add(newNode);
    }

    public List<MutableTreeNode> getChildren() {
        return this.children;
    }

    public String toString() {
        return this.label + ":" + "\t posTag: " + this.posTag + "\t lemma: " + this.lemma + "\t depLabel: " + this.depLabel;
    }

    @Override
    public int compareTo(MutableTreeNode o) {
        if (this.nodeNumber > o.nodeNumber) {
            return 1;
        }
        return -1;
    }

    public void isUsed() {
        this.used = true;
    }

    public boolean used() {
        return this.used;
    }

    public void addAnnotation(String resourceImpl) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        if (!resourceImpl.isEmpty()) {
            this.annotations.add(resourceImpl);
        }
    }

    public List<String> getAnnotations() {
        if (this.annotations == null) {
            return new ArrayList<String>();
        }
        return this.annotations;
    }

    public String getDepLabel() {
        return this.depLabel;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPosTag() {
        return this.posTag;
    }

    public String getLemma() {
        return this.lemma;
    }

    public void setDepLabel(String depLabel) {
        this.depLabel = depLabel;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setPosTag(String posTag) {
        this.posTag = posTag;
    }

    public void setLemma(String lemma) {
        this.lemma = lemma;
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int labelPosition) {
        this.labelPosition = labelPosition;
    }

    public int getDepth() {
        return this.depth;
    }
}

