/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.index;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.aksw.hawk.index.Patty_relations;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikipediaPatternsConfidence_Index {
    private static final Version LUCENE_VERSION = Version.LUCENE_46;
    private Logger log = LoggerFactory.getLogger(Patty_relations.class);
    private int numberOfDocsRetrievedFromIndex = 100;
    public String FIELD_NAME_PATTERNTEXT = "patterntext";
    public String FIELD_NAME_CONFIDENCE = "confidence";
    public String FIELD_NAME_DOMAIN = "domain";
    public String FIELD_NAME_RANGE = "range";
    private Directory directory;
    private IndexSearcher isearcher;
    private DirectoryReader ireader;
    private IndexWriter iwriter;
    private WhitespaceAnalyzer analyzer;

    public WikipediaPatternsConfidence_Index() {
        try {
            File indexDir = new File("resources/WikipediaPatternsConfidenceIndex");
            this.analyzer = new WhitespaceAnalyzer(LUCENE_VERSION);
            if (!indexDir.exists()) {
                indexDir.mkdir();
                IndexWriterConfig config = new IndexWriterConfig(LUCENE_VERSION, (Analyzer)this.analyzer);
                this.directory = new MMapDirectory(indexDir);
                this.iwriter = new IndexWriter(this.directory, config);
                this.index();
            } else {
                this.directory = new MMapDirectory(indexDir);
            }
            this.ireader = DirectoryReader.open((Directory)this.directory);
            this.isearcher = new IndexSearcher((IndexReader)this.ireader);
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void index() {
        try {
            Path currentDir = Paths.get(".", new String[0]);
            Path path = currentDir.resolve("resources/wikipedia-patterns.txt");
            Stream<String> lines = Files.lines(path);
            lines.forEach(x -> this.lineToFieldsAndAdd(x));
            lines.close();
            this.iwriter.commit();
            this.iwriter.close();
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void addToIndex(String pattern, String confidence, String domain, String range) {
        try {
            Document doc = new Document();
            doc.add((IndexableField)new TextField(this.FIELD_NAME_PATTERNTEXT, pattern, Field.Store.YES));
            doc.add((IndexableField)new StringField(this.FIELD_NAME_CONFIDENCE, confidence, Field.Store.YES));
            doc.add((IndexableField)new StringField(this.FIELD_NAME_DOMAIN, domain, Field.Store.YES));
            doc.add((IndexableField)new StringField(this.FIELD_NAME_RANGE, range, Field.Store.YES));
            this.iwriter.addDocument((Iterable)doc);
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void lineToFieldsAndAdd(String line) {
        String[] tokens;
        String[] fields = line.split("\\t");
        String relations = fields[1];
        String confidence = fields[2];
        String domain = fields[3];
        String range = fields[4];
        for (String token : tokens = relations.split("\\;\\$")) {
            this.addToIndex(token, confidence, domain, range);
        }
    }

    public ArrayList<String[]> search(String pattern) {
        ArrayList<String[]> values = new ArrayList<String[]>();
        try {
            ScoreDoc[] hits;
            String[] words;
            PhraseQuery query = new PhraseQuery();
            for (String word : words = pattern.split(" ")) {
                query.add(new Term(this.FIELD_NAME_PATTERNTEXT, word));
            }
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)this.numberOfDocsRetrievedFromIndex, (boolean)true);
            this.isearcher.search((Query)query, (Collector)collector);
            for (ScoreDoc hit : hits = collector.topDocs().scoreDocs) {
                String[] hitList = new String[3];
                Document hitDoc = this.isearcher.doc(hit.doc);
                String hitConfidence = hitDoc.get(this.FIELD_NAME_CONFIDENCE);
                String hitDomain = hitDoc.get(this.FIELD_NAME_DOMAIN);
                String hitRange = hitDoc.get(this.FIELD_NAME_RANGE);
                hitList[0] = hitConfidence;
                hitList[1] = hitDomain;
                hitList[2] = hitRange;
                if (!hitDoc.get(this.FIELD_NAME_PATTERNTEXT).equals(pattern)) continue;
                values.add(hitList);
                this.log.debug(pattern + " -> " + hitDoc.get(this.FIELD_NAME_PATTERNTEXT) + " " + hitConfidence + " " + hitDomain + " " + hitRange);
            }
            System.out.println(collector.toString());
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return values;
    }
}

