/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.experiment;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.aksw.hawk.controller.EvalObj;
import org.aksw.hawk.controller.PipelineStanford;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.datastructures.HAWKQuestionFactory;
import org.aksw.hawk.experiment.Measures;
import org.aksw.hawk.ranking.FeatureBasedRanker;
import org.aksw.hawk.ranking.OptimalRanker;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingPipeline {
    static Logger log = LoggerFactory.getLogger(TrainingPipeline.class);

    public static void main(String[] args) throws IOException, ParserConfigurationException {
        log.info("Configuring controller");
        PipelineStanford pipeline = new PipelineStanford();
        log.info("Loading dataset");
        List questions = HAWKQuestionFactory.createInstances((List)LoaderController.load((Dataset)Dataset.QALD6_Train_Multilingual));
        double average = 0.0;
        double count = 0.0;
        double countNULLAnswer = 0.0;
        for (HAWKQuestion q : questions) {
            if (!(q.getAnswerType().equals("resource") & q.getOnlydbo() & q.getAggregation() == false) && !q.getLoadedAsASKQuery().booleanValue()) continue;
            log.info("Run pipeline on " + (String)q.getLanguageToQuestion().get("en"));
            List answers = pipeline.getAnswersToQuestion(q);
            if (answers.isEmpty()) {
                log.warn("Question#" + q.getId() + " returned no answers! (Q: " + (String)q.getLanguageToQuestion().get("en") + ")");
                countNULLAnswer += 1.0;
                continue;
            }
            count += 1.0;
            log.info("Run ranking");
            int maximumPositionToMeasure = 10;
            OptimalRanker optimal_ranker = new OptimalRanker();
            FeatureBasedRanker feature_ranker = new FeatureBasedRanker();
            log.info("Optimal ranking");
            List rankedAnswer = optimal_ranker.rank(answers, q);
            List eval = Measures.measure((List)rankedAnswer, (HAWKQuestion)q, (int)maximumPositionToMeasure);
            log.debug(Joiner.on((String)"\n\t").join((Iterable)eval));
            HashSet queries = Sets.newHashSet();
            double fmax = 0.0;
            for (EvalObj e : eval) {
                if (e.getFmax() == fmax) {
                    queries.add(e.getAnswer().query);
                    continue;
                }
                if (!(e.getFmax() > fmax)) continue;
                queries.clear();
                queries.add(e.getAnswer().query);
                fmax = e.getFmax();
            }
            log.info("Max F-measure: " + fmax);
            average += fmax;
            log.info("Feature-based ranking begins training.");
            feature_ranker.learn((IQuestion)q, (Set)queries);
        }
        log.info("Number of questions with answer: " + count + ", number of questions without answer: " + countNULLAnswer);
        log.info("Average F-measure: " + average / count);
    }
}

