/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.experiment;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.aksw.hawk.controller.PipelineStanford;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.datastructures.HAWKQuestionFactory;
import org.aksw.hawk.experiment.Measures;
import org.aksw.hawk.ranking.BucketRanker;
import org.aksw.hawk.ranking.FeatureBasedRanker;
import org.aksw.hawk.ranking.OptimalRanker;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RankingPipeline {
    static Logger log = LoggerFactory.getLogger(RankingPipeline.class);

    public static void main(String[] args) throws IOException, ParserConfigurationException {
        log.info("Configuring controller");
        PipelineStanford pipeline = new PipelineStanford();
        log.info("Loading dataset");
        List questions = HAWKQuestionFactory.createInstances((List)LoaderController.load((Dataset)Dataset.QALD6_Train_Multilingual));
        for (HAWKQuestion q : questions) {
            if (!(q.getHybrid() & q.getAnswerType().equals("resource") & q.getOnlydbo() & q.getAggregation() == false) && !q.getLoadedAsASKQuery().booleanValue()) continue;
            log.info("Run pipeline on " + (String)q.getLanguageToQuestion().get("en"));
            List answers = pipeline.getAnswersToQuestion(q);
            log.info("Run ranking");
            int maximumPositionToMeasure = 10;
            OptimalRanker optimal_ranker = new OptimalRanker();
            FeatureBasedRanker feature_ranker = new FeatureBasedRanker();
            BucketRanker bucket_ranker = new BucketRanker();
            log.info("Bucket-based ranking");
            List rankedAnswer = bucket_ranker.rank(answers, q);
            List eval = Measures.measure((List)rankedAnswer, (HAWKQuestion)q, (int)maximumPositionToMeasure);
            log.info(Joiner.on((String)"\n\t").join((Iterable)eval));
        }
    }
}

