/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.experiment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.aksw.hawk.controller.EvalObj;
import org.aksw.hawk.datastructures.Answer;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.qald.QALD4_EvaluationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Measures {
    static Logger log = LoggerFactory.getLogger(Measures.class);

    public static List<EvalObj> measure(List<Answer> rankedAnswer, HAWKQuestion q, int maxK) {
        ArrayList list = Lists.newArrayList();
        for (Answer answer : rankedAnswer) {
            Set answerSet = answer.answerSet;
            double precision = QALD4_EvaluationUtils.precision((Set)answerSet, (IQuestion)q);
            double recall = QALD4_EvaluationUtils.recall((Set)answerSet, (IQuestion)q);
            double fMeasure = QALD4_EvaluationUtils.fMeasure((Set)answerSet, (IQuestion)q);
            log.debug("Measure @" + (list.size() + 1) + "P=" + precision + " R=" + recall + " F=" + fMeasure);
            list.add(new EvalObj(q.getId(), (String)q.getLanguageToQuestion().get("en"), fMeasure, precision, recall, "Measure @" + (list.size() + 1), answer));
            if (list.size() <= maxK) continue;
            break;
        }
        return list;
    }
}

