/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.experiment;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.CoreMap;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.aksw.hawk.datastructures.HAWKQuestionFactory;
import org.aksw.qa.commons.datastructure.Question;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;

public class Inzidenzmatrix {
    public static void main(String[] args) {
        List questions = null;
        questions = HAWKQuestionFactory.createInstances((List)LoaderController.load((Dataset)Dataset.QALD6_Train_Hybrid));
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit, pos, lemma, ner, parse");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        for (Question q : questions) {
            int j;
            int i;
            String text = (String)q.getLanguageToQuestion().get("en");
            System.out.println("\n" + text);
            Annotation doc = new Annotation(text);
            pipeline.annotate(doc);
            List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
            CoreMap sen = (CoreMap)sentences.get(0);
            SemanticGraph graph = (SemanticGraph)sen.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class);
            SemanticGraphEdge[] edges = (SemanticGraphEdge[])graph.edgeListSorted().stream().toArray(SemanticGraphEdge[]::new);
            Object[] vertices = (IndexedWord[])graph.vertexSet().stream().toArray(IndexedWord[]::new);
            Integer[][] incidenceMatrix = new Integer[vertices.length][edges.length];
            for (i = 0; i < vertices.length; ++i) {
                for (j = 0; j < edges.length; ++j) {
                    incidenceMatrix[i][j] = 0;
                }
            }
            for (i = 0; i < vertices.length; ++i) {
                for (j = 0; j < edges.length; ++j) {
                    Object vertex = vertices[i];
                    SemanticGraphEdge edge = edges[j];
                    if (!vertex.equals((Object)edge.getSource()) && !vertex.equals((Object)edge.getTarget())) continue;
                    incidenceMatrix[i][j] = 1;
                }
            }
            System.out.println(graph);
            System.out.println(Arrays.toString(vertices));
            System.out.println(edges);
            for (i = 0; i < vertices.length; ++i) {
                System.out.println(Arrays.toString(incidenceMatrix[i]) + "\n");
            }
        }
    }
}

