/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.experiment;

import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.trees.Tree;
import java.util.List;
import org.aksw.hawk.datastructures.HAWKQuestionFactory;
import org.aksw.qa.commons.datastructure.Question;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;

public class ConstituentParsingStanford {
    public static void main(String[] args) {
        Document doc;
        String text;
        List questions = null;
        questions = HAWKQuestionFactory.createInstances((List)LoaderController.load((Dataset)Dataset.QALD6_Train_Hybrid));
        for (Question q : questions) {
            text = (String)q.getLanguageToQuestion().get("en");
            System.out.println("\n" + text);
            doc = new Document(text);
            for (Sentence sent : doc.sentences()) {
                for (Tree tree : sent.parse().subTreeList()) {
                    if (!tree.isPhrasal() || !tree.label().value().equals("NP") || tree.children().length <= 1) continue;
                    boolean containsPPorVP = false;
                    for (Tree subtree : tree.subTreeList()) {
                        if (!subtree.isPhrasal() || !subtree.label().value().matches("PP||VP")) continue;
                        containsPPorVP = true;
                        break;
                    }
                    if (containsPPorVP) continue;
                    System.out.println(tree.toString());
                }
            }
        }
        for (Question q : questions) {
            text = (String)q.getLanguageToQuestion().get("en");
            System.out.println("\n" + text);
            doc = new Document(text);
            for (Sentence sent : doc.sentences()) {
                for (String keyphrase : sent.algorithms().keyphrases()) {
                    System.out.println(keyphrase);
                }
            }
        }
    }
}

