/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.datastructures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.aksw.hawk.datastructures.Answer;
import org.aksw.hawk.nlp.MutableTree;
import org.aksw.hawk.util.JSONStatusBuilder;
import org.aksw.qa.commons.datastructure.Entity;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.datastructure.Question;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class HAWKQuestion
extends Question
implements IQuestion,
Serializable {
    private static final long serialVersionUID = 1L;
    private int cardinality;
    private Boolean isClassifiedAsASKQuery;
    private Boolean loadedAsASKQuery;
    private MutableTree tree;
    private Map<String, List<Entity>> languageToNamedEntites = new LinkedHashMap();
    private Map<String, List<Entity>> languageToNounPhrases = new LinkedHashMap();
    private Map<String, List<Entity>> goldEntites = new HashMap();
    private UUID UUID;
    private boolean finished;
    private List<Answer> finalAnswer;
    private JSONObject tree_full;
    private JSONObject tree_pruned;
    private JSONObject tree_final;
    private JSONArray pruning_messages = new JSONArray();

    public HAWKQuestion() {
        this.goldEntites.put("en", new ArrayList());
        this.goldEntites.put("de", new ArrayList());
    }

    public HAWKQuestion(String englishQuestion) {
        this();
        this.getLanguageToQuestion().put("en", englishQuestion);
    }

    public String toString() {
        String output = String.format("id: %s answerType: %s aggregation: %s onlydbo: %s\n", this.getId(), this.getAnswerType(), this.getAggregation(), this.getOnlydbo());
        for (Map.Entry entry : this.getLanguageToQuestion().entrySet()) {
            output = output + "\t" + (String)entry.getKey() + "\tQuestion: " + (String)entry.getValue() + "\n";
            output = output + "\t\tKeywords: " + StringUtils.join((Iterable)((Iterable)this.getLanguageToKeywords().get(entry.getKey())), (String)", ") + "\n";
            output = output + "\t\tGold-Entities: " + StringUtils.join((Object[])new Object[]{this.goldEntites, ", "}) + "\n";
            if (this.getLanguageToNamedEntites().containsKey(entry.getKey())) {
                output = output + "\t\tEntities: " + StringUtils.join((Iterable)((Iterable)this.getLanguageToNamedEntites().get(entry.getKey())), (String)", ") + "\n";
            }
            if (!this.getLanguageToNounPhrases().containsKey(entry.getKey())) continue;
            output = output + "\t\tNouns: " + StringUtils.join((Iterable)((Iterable)this.getLanguageToNounPhrases().get(entry.getKey())), (String)", ") + "\n";
        }
        output = output + "PseudoSPARQL: " + this.getPseudoSparqlQuery() + "\n";
        output = output + "SPARQL: " + this.getSparqlQuery() + "\n";
        output = output + "Answers: " + StringUtils.join((Iterable)this.getGoldenAnswers(), (String)", ") + "\n";
        return output;
    }

    public String getJSONStatus() {
        JSONObject sb = JSONStatusBuilder.status((HAWKQuestion)this);
        return sb.toJSONString();
    }

    public JSONObject getTree_full() {
        return this.tree_full;
    }

    public void setTree_full(JSONObject tree_full) {
        this.tree_full = tree_full;
    }

    public Boolean getIsClassifiedAsASKQuery() {
        return this.isClassifiedAsASKQuery;
    }

    public void setIsClassifiedAsASKQuery(Boolean isClassifiedAsASKQuery) {
        this.isClassifiedAsASKQuery = isClassifiedAsASKQuery;
    }

    public Boolean getLoadedAsASKQuery() {
        return this.loadedAsASKQuery;
    }

    public void setLoadedAsASKQuery(Boolean loadedAsASKQuery) {
        this.loadedAsASKQuery = loadedAsASKQuery;
    }

    public Map<String, List<Entity>> getLanguageToNamedEntites() {
        return this.languageToNamedEntites;
    }

    public void setLanguageToNamedEntites(Map<String, List<Entity>> languageToNamedEntites) {
        this.languageToNamedEntites = languageToNamedEntites;
    }

    public Map<String, List<Entity>> getLanguageToNounPhrases() {
        return this.languageToNounPhrases;
    }

    public void setLanguageToNounPhrases(Map<String, List<Entity>> languageToNounPhrases) {
        this.languageToNounPhrases = languageToNounPhrases;
    }

    public MutableTree getTree() {
        return this.tree;
    }

    public void setTree(MutableTree tree) {
        this.tree = tree;
    }

    public JSONObject getTree_final() {
        return this.tree_final;
    }

    public void setTree_final(JSONObject tree_final) {
        this.tree_final = tree_final;
    }

    public JSONObject getTree_pruned() {
        return this.tree_pruned;
    }

    public void setTree_pruned(JSONObject tree_pruned) {
        this.tree_pruned = tree_pruned;
    }

    public JSONArray getPruning_messages() {
        return this.pruning_messages;
    }

    public void setPruning_messages(JSONArray pruning_messages) {
        this.pruning_messages = pruning_messages;
    }

    public List<Answer> getFinalAnswer() {
        return this.finalAnswer;
    }

    public void setFinalAnswer(List<Answer> finalAnswer) {
        this.finalAnswer = finalAnswer;
    }

    public UUID getUUID() {
        return this.UUID;
    }

    public void setUUID(UUID uUID) {
        this.UUID = uUID;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public boolean checkSuitabillity() {
        return this.getAnswerType().matches("resource||boolean") & this.getOnlydbo() & this.getAggregation() == false;
    }
}

