/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.controller;

import java.util.List;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.datastructures.HAWKQuestionFactory;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTypeClassifier {
    static Logger log = LoggerFactory.getLogger(QueryTypeClassifier.class);

    public Boolean isASKQuery(String question) {
        return question.startsWith("Are ") || question.startsWith("Did ") || question.startsWith("Do ") || question.startsWith("Does ") || question.startsWith("Is ") || question.startsWith("Was ");
    }

    public static void main(String[] args) {
        log.info("Test QueryType classification ...");
        log.debug("Initialize components ...");
        LoaderController datasetLoader = new LoaderController();
        QueryTypeClassifier queryTypeClassifier = new QueryTypeClassifier();
        log.info("Run queries through components ...");
        for (Dataset d : Dataset.values()) {
            log.debug("Load data file: " + d);
            List questions = HAWKQuestionFactory.createInstances((List)LoaderController.load((Dataset)d));
            int counter = 0;
            int counterASK = 0;
            int counterClassifiedWrong = 0;
            for (HAWKQuestion q : questions) {
                q.setIsClassifiedAsASKQuery(queryTypeClassifier.isASKQuery((String)q.getLanguageToQuestion().get("en")));
                if (log.isDebugEnabled()) {
                    log.debug("Question ID=" + q.getId() + ": isASK=" + q.getIsClassifiedAsASKQuery() + " - " + (String)q.getLanguageToQuestion().get("en"));
                }
                if (q.getIsClassifiedAsASKQuery().booleanValue()) {
                    ++counterASK;
                }
                ++counter;
                if (q.getIsClassifiedAsASKQuery().booleanValue() == q.getLoadedAsASKQuery().booleanValue()) continue;
                log.warn("Expected ASK query classification: " + q.getLoadedAsASKQuery() + ", got: " + q.getIsClassifiedAsASKQuery() + ", for: " + (String)q.getLanguageToQuestion().get("en"));
                ++counterClassifiedWrong;
            }
            log.info("Classified " + counterClassifiedWrong + " wrong from " + counter + " queries. (" + counterASK + " are ASK)");
        }
    }
}

