/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.controller;

import java.util.List;
import org.aksw.hawk.controller.AbstractPipeline;
import org.aksw.hawk.controller.Cardinality;
import org.aksw.hawk.controller.QueryTypeClassifier;
import org.aksw.hawk.controller.StanfordNLPConnector;
import org.aksw.hawk.datastructures.Answer;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.nlp.MutableTreePruner;
import org.aksw.hawk.nouncombination.NounCombinationChain;
import org.aksw.hawk.nouncombination.NounCombiners;
import org.aksw.hawk.number.UnitController;
import org.aksw.hawk.querybuilding.Annotater;
import org.aksw.hawk.querybuilding.SPARQLQueryBuilder;
import org.aksw.qa.annotation.spotter.ASpotter;
import org.aksw.qa.annotation.spotter.Spotlight;
import org.aksw.qa.commons.sparql.SPARQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineStanford
extends AbstractPipeline {
    static Logger log = LoggerFactory.getLogger(PipelineStanford.class);
    private ASpotter nerdModule;
    private MutableTreePruner pruner;
    private Annotater annotater;
    private SPARQLQueryBuilder queryBuilder;
    private Cardinality cardinality;
    private QueryTypeClassifier queryTypeClassifier = new QueryTypeClassifier();
    private StanfordNLPConnector stanfordConnector;
    private UnitController numberToDigit;
    private NounCombinationChain nounCombination;

    public PipelineStanford() {
        this.nerdModule = new Spotlight();
        this.stanfordConnector = new StanfordNLPConnector();
        this.numberToDigit = new UnitController();
        this.numberToDigit.instantiateEnglish(this.stanfordConnector);
        this.nounCombination = new NounCombinationChain(NounCombiners.HawkRules, new NounCombiners[]{NounCombiners.StanfordDependecy});
        this.cardinality = new Cardinality();
        this.pruner = new MutableTreePruner();
        SPARQL sparql = new SPARQL();
        this.annotater = new Annotater(sparql);
        this.queryBuilder = new SPARQLQueryBuilder(sparql);
    }

    public List<Answer> getAnswersToQuestion(HAWKQuestion q) {
        log.info("Question: " + (String)q.getLanguageToQuestion().get("en"));
        log.info("Classify question type.");
        q.setIsClassifiedAsASKQuery(this.queryTypeClassifier.isASKQuery((String)q.getLanguageToQuestion().get("en")));
        log.info("Named entity recognition.");
        q.setLanguageToNamedEntites(this.nerdModule.getEntities((String)q.getLanguageToQuestion().get("en")));
        log.info("Noun phrase combination / Dependency Parsing");
        q.setTree(this.stanfordConnector.parseTree(q, this.numberToDigit));
        this.nounCombination.runChain(q);
        log.info("Cardinality calculation.");
        q.setCardinality(this.cardinality.cardinality(q));
        log.info("Pruning tree.");
        q.setTree(this.pruner.prune(q));
        log.info("Semantically annotating the tree.");
        this.annotater.annotateTree(q);
        log.info("Calculating SPARQL representations.");
        List answers = this.queryBuilder.build(q);
        return answers;
    }

    public StanfordNLPConnector getStanfordConnector() {
        return this.stanfordConnector;
    }

    public static void main(String[] args) {
        PipelineStanford p = new PipelineStanford();
        HAWKQuestion q = new HAWKQuestion();
        q.getLanguageToQuestion().put("en", "Which anti-apartheid activist was born in Mvezo?");
        p.getAnswersToQuestion(q);
    }
}

