/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.controller;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.qa.commons.datastructure.Entity;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HAWKUtils {
    private static Logger log = LoggerFactory.getLogger(HAWKUtils.class);

    private HAWKUtils() {
    }

    public static String replaceLabelsByIdentifiedURIs(String sentence, List<Entity> list) {
        ArrayList<String> textParts = new ArrayList<String>();
        list.sort(Comparator.comparing(Entity::getOffset).reversed());
        int startFormerLabel = sentence.length();
        for (Entity currentNE : list) {
            int currentNEStartPos = currentNE.getOffset();
            int currentNEEndPos = currentNEStartPos + currentNE.getLabel().length();
            if (startFormerLabel < currentNEEndPos) continue;
            textParts.add(sentence.substring(currentNEEndPos, startFormerLabel));
            textParts.add(((Resource)currentNE.getUris().get(0)).getURI());
            startFormerLabel = currentNEStartPos;
        }
        if (startFormerLabel > 0) {
            textParts.add(sentence.substring(0, startFormerLabel));
        }
        StringBuilder textWithMarkups = new StringBuilder();
        for (int i = textParts.size() - 1; i >= 0; --i) {
            textWithMarkups.append((String)textParts.get(i));
        }
        return textWithMarkups.toString();
    }

    public static String replaceNamedEntitysWithURL(HAWKQuestion q) {
        String sentence = (String)q.getLanguageToQuestion().get("en");
        if (!q.getLanguageToNamedEntites().isEmpty()) {
            sentence = HAWKUtils.replaceLabelsByIdentifiedURIs((String)sentence, (List)((List)q.getLanguageToNamedEntites().get("en")));
            log.debug(sentence);
        }
        if (!q.getLanguageToNounPhrases().isEmpty()) {
            sentence = HAWKUtils.replaceLabelsByIdentifiedURIs((String)sentence, (List)((List)q.getLanguageToNounPhrases().get("en")));
            log.debug(sentence);
        }
        return sentence;
    }
}

