/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.controller;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.datastructures.HAWKQuestionFactory;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;
import org.aksw.qa.commons.qald.QALD4_EvaluationUtils;
import org.apache.jena.rdf.model.RDFNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Baseline {
    static Logger log = LoggerFactory.getLogger(Baseline.class);
    String dataset;

    void run(Dataset dataset) throws IOException {
        List questions = HAWKQuestionFactory.createInstances((List)LoaderController.load((Dataset)dataset));
        double overallf = 0.0;
        double overallp = 0.0;
        double overallr = 0.0;
        double counter = 0.0;
        for (HAWKQuestion q : questions) {
            if (!q.getAnswerType().equals("resource") || !q.getOnlydbo().booleanValue() || q.getAggregation().booleanValue()) continue;
            Map answer = this.calculateSPARQLRepresentation(q);
            double fmax = 0.0;
            double pmax = 0.0;
            double rmax = 0.0;
            for (String query : answer.keySet()) {
                Set systemAnswers = (Set)answer.get(query);
                double precision = QALD4_EvaluationUtils.precision((Set)systemAnswers, (IQuestion)q);
                double recall = QALD4_EvaluationUtils.recall((Set)systemAnswers, (IQuestion)q);
                double fMeasure = QALD4_EvaluationUtils.fMeasure((Set)systemAnswers, (IQuestion)q);
                if (!(fMeasure > fmax)) continue;
                log.info(query.substring(0, Math.min(1000, query.length())));
                log.info("\tP=" + precision + " R=" + recall + " F=" + fMeasure);
                fmax = fMeasure;
                pmax = precision;
                rmax = recall;
            }
            overallf += fmax;
            overallp += pmax;
            overallr += rmax;
            counter += 1.0;
            log.info("########################################################");
        }
        log.info("Average P=" + overallp / counter + " R=" + overallr / counter + " F=" + overallf / counter + " Counter=" + counter);
    }

    public Map<String, Set<RDFNode>> calculateSPARQLRepresentation(HAWKQuestion q) {
        HashMap answer = Maps.newHashMap();
        return answer;
    }

    public static void main(String[] args) throws IOException {
        log.info("Configuring controller");
        Baseline controller = new Baseline();
        Dataset dataset = Dataset.QALD5_Train_Hybrid;
        log.info("Run controller");
        controller.run(dataset);
    }
}

